% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_findAdjacentDistances.R
\name{table_findAdjacentDistances}
\alias{table_findAdjacentDistances}
\title{Find distances between adjacent locations in a known locations table}
\usage{
table_findAdjacentDistances(
  locationTbl = NULL,
  distanceThreshold = NULL,
  measure = c("geodesic", "haversine", "vincenty", "cheap")
)
}
\arguments{
\item{locationTbl}{Tibble of known locations.}

\item{distanceThreshold}{Distance in meters.}

\item{measure}{One of "haversine" "vincenty", "geodesic", or "cheap"
specifying desired method of geodesic distance calculation.

See \code{geodist::\link[geodist:geodist]{geodist}} for details.}
}
\value{
Tibble of row indices and distances for those locations separated by
less than \code{distanceThreshold} meters.
}
\description{
Calculate distances between all locations within a known
locations table and return a tibble with the row indices and separation
distances of those records separated by less than \code{distanceThreshold}
meters. Records are returned in order of distance.

It is useful when working with new metadata tables to identify adjacent
locations early on so that decisions can be made about the appropriateness
of the specified \code{distanceThreshold}.
}
\note{
The measure \code{"cheap"} may be used to speed things up depending on
the spatial scale being considered. Distances calculated with
\code{measure = "cheap"} will vary by a few meters compared with those
calculated using \code{measure = "geodesic"}.
}
\examples{
library(MazamaLocationUtils)

meta <- wa_airfire_meta

# Any locations closer than 2 km?
table_findAdjacentDistances(meta, distanceThreshold = 2000)

# How about 4 km?
table_findAdjacentDistances(meta, distanceThreshold = 4000)


}
