% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{or_monitors_500}
\alias{or_monitors_500}
\title{Oregon monitor locations dataset}
\format{
A tibble with 64 rows and 13 columns of data.
}
\usage{
or_monitors_500
}
\description{
The \code{or_monitor_500} dataset provides a set of known
locations associated with Oregon state air quality monitors.
This dataset was generated on 2023-10-24 by running:

\preformatted{
library(AirMonitor)
library(MazamaLocationUtils)

initializeMazamaSpatialUtils()
setLocationDataDir("./data")

monitor <- monitor_loadLatest() \%>\% monitor_filter(stateCode == "OR")
lons <- monitor$meta$longitude
lats <- monitor$meta$latitude

table_initialize() \%>\%
  table_addLocation(
    lons, lats, 
      distanceThreshold = 500,
      elevationService = "usgs",
      addressService = "photon"
    ) \%>\%
  table_save("or_monitors_500")
}
}
\seealso{
\link{id_monitors_500}

\link{wa_monitors_500}
}
\keyword{datasets}
