% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rx.R
\name{r1}
\alias{r1}
\alias{r2}
\alias{r3}
\alias{r4}
\alias{GCD}
\title{Correlational Measures for Matrices}
\usage{
r1(X1, X2, center = TRUE)

r2(X1, X2, center = TRUE)

r3(X1, X2, center = TRUE)

r4(X1, X2, center = TRUE)

GCD(X1, X2, ncomp1 = Rank(X1), ncomp2 = Rank(X2), center = TRUE)
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{center}{\code{logical} indicating if input matrices should be centered (default = TRUE).}

\item{ncomp1}{(GCD) number of subspace components from the first \code{matrix} (default: full subspace).}

\item{ncomp2}{(GCD) number of subspace components from the second \code{matrix} (default: full subspace).}
}
\value{
A single value measuring the similarity of two matrices.
}
\description{
Matrix similarity as described by Ramsey et al. (1984).
}
\details{
Details can be found in Ramsey's paper:
\itemize{
 \item{r1:}{ inner product correlation}
 \item{r2:}{ orientation-independent inner product correlation}
 \item{r3:}{ spectra-independent inner product correlations (including orientation)}
 \item{r4:}{ Spectra-Independent inner product Correlations}
 \item{GCD:}{ Yanai's Generalized Coefficient of Determination (GCD) Measure. To reproduce the original GCD, use all components. When \code{X1} and \code{X2} are dummy variables, GCD is proportional with Pillai's criterion: tr(W^-1(B+W)).}
}
}
\examples{
X1  <- matrix(rnorm(100*300),100,300)
usv <- svd(X1)
X2  <- usv$u[,-3] \%*\% diag(usv$d[-3]) \%*\% t(usv$v[,-3])

r1(X1,X2)
r2(X1,X2)
r3(X1,X2)
r4(X1,X2)
GCD(X1,X2)
GCD(X1,X2, 5,5)

}
\references{
Ramsay, JO; Berg, JT; Styan, GPH; 1984. "Matrix Correlation". Psychometrica 49(3): 403-423.
}
\seealso{
\code{\link{SMI}}, \code{\link{RV}} (RV2/RVadj).
}
\author{
Kristian Hovde Liland
}
