% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihoods.R
\name{logL_monitoring}
\alias{logL_monitoring}
\title{Log-Likelihood for monitoring the EM algorithm in Magma}
\usage{
logL_monitoring(
  hp_0,
  hp_i,
  db,
  m_0,
  kern_0,
  kern_i,
  post_mean,
  post_cov,
  pen_diag
)
}
\arguments{
\item{hp_0}{A named vector, tibble or data frame, containing the
hyper-parameters associated with the mean GP.}

\item{hp_i}{A tibble or data frame, containing the hyper-parameters with the
individual GPs.}

\item{db}{A tibble or data frame. Columns required: ID, Input, Output.
Additional columns for covariates can be specified.}

\item{m_0}{A vector, corresponding to the prior mean of the mean GP.}

\item{kern_0}{A kernel function, associated with the mean GP.}

\item{kern_i}{A kernel function, associated with the individual GPs.}

\item{post_mean}{A tibble, coming out of the E step, containing the Input and
associated Output of the hyper-posterior mean parameter.}

\item{post_cov}{A matrix, coming out of the E step, being the hyper-posterior
covariance parameter.}

\item{pen_diag}{A jitter term that is added to the covariance matrix to avoid
numerical issues when inverting, in cases of nearly singular matrices.}
}
\value{
A number, expectation of joint log-likelihood of the model. This
quantity is supposed to increase at each step of the EM algorithm, and
thus used for monitoring the procedure.
}
\description{
Log-Likelihood for monitoring the EM algorithm in Magma
}
\examples{
TRUE
}
\keyword{internal}
