% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{performance}
\alias{performance}
\alias{performance.BinomialVariate}
\alias{performance.factor}
\alias{performance.matrix}
\alias{performance.numeric}
\alias{performance.Surv}
\alias{performance.ConfusionList}
\alias{performance.ConfusionMatrix}
\alias{performance.MLModel}
\alias{performance.Resample}
\alias{performance.TrainingStep}
\title{Model Performance Metrics}
\usage{
performance(x, ...)

\method{performance}{BinomialVariate}(
  x,
  y,
  weights = NULL,
  metrics = MachineShop::settings("metrics.numeric"),
  na.rm = TRUE,
  ...
)

\method{performance}{factor}(
  x,
  y,
  weights = NULL,
  metrics = MachineShop::settings("metrics.factor"),
  cutoff = MachineShop::settings("cutoff"),
  na.rm = TRUE,
  ...
)

\method{performance}{matrix}(
  x,
  y,
  weights = NULL,
  metrics = MachineShop::settings("metrics.matrix"),
  na.rm = TRUE,
  ...
)

\method{performance}{numeric}(
  x,
  y,
  weights = NULL,
  metrics = MachineShop::settings("metrics.numeric"),
  na.rm = TRUE,
  ...
)

\method{performance}{Surv}(
  x,
  y,
  weights = NULL,
  metrics = MachineShop::settings("metrics.Surv"),
  cutoff = MachineShop::settings("cutoff"),
  na.rm = TRUE,
  ...
)

\method{performance}{ConfusionList}(x, ...)

\method{performance}{ConfusionMatrix}(x, metrics = MachineShop::settings("metrics.ConfusionMatrix"), ...)

\method{performance}{MLModel}(x, ...)

\method{performance}{Resample}(x, ...)

\method{performance}{TrainingStep}(x, ...)
}
\arguments{
\item{x}{\link[=response]{observed responses}; or \link{confusion}, trained
model \link{fit}, \link{resample}, or \link{rfe} result.}

\item{...}{arguments passed from the \code{Resample} method to the response
type-specific methods or from the method for \code{ConfusionList} to
\code{ConfusionMatrix}.  Elliptical arguments in the response
type-specific methods are passed to \code{metrics} supplied as a single
\code{\link[=metrics]{MLMetric}} function and are ignored otherwise.}

\item{y}{\link[=predict]{predicted responses} if not contained in \code{x}.}

\item{weights}{numeric vector of non-negative
\link[=case_weights]{case weights} for the observed \code{x} responses
[default: equal weights].}

\item{metrics}{\link[=metrics]{metric} function, function name, or vector of
these with which to calculate performance.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating metrics.}

\item{cutoff}{numeric (0, 1) threshold above which binary factor
probabilities are classified as events and below which survival
probabilities are classified.}
}
\description{
Compute measures of model performance.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

res <- resample(Species ~ ., data = iris, model = GBMModel)
(perf <- performance(res))
summary(perf)
plot(perf)

## Survival response example
library(survival)

gbm_fit <- fit(Surv(time, status) ~ ., data = veteran, model = GBMModel)

obs <- response(gbm_fit, newdata = veteran)
pred <- predict(gbm_fit, newdata = veteran)
performance(obs, pred)
}

}
\seealso{
\code{\link{plot}}, \code{\link{summary}}
}
