% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_RangerModel.R
\name{RangerModel}
\alias{RangerModel}
\title{Fast Random Forest Model}
\usage{
RangerModel(
  num.trees = 500,
  mtry = integer(),
  importance = c("impurity", "impurity_corrected", "permutation"),
  min.node.size = integer(),
  replace = TRUE,
  sample.fraction = if (replace) 1 else 0.632,
  splitrule = character(),
  num.random.splits = 1,
  alpha = 0.5,
  minprop = 0.1,
  split.select.weights = numeric(),
  always.split.variables = character(),
  respect.unordered.factors = character(),
  scale.permutation.importance = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{num.trees}{number of trees.}

\item{mtry}{number of variables to possibly split at in each node.}

\item{importance}{variable importance mode.}

\item{min.node.size}{minimum node size.}

\item{replace}{logical indicating whether to sample with replacement.}

\item{sample.fraction}{fraction of observations to sample.}

\item{splitrule}{splitting rule.}

\item{num.random.splits}{number of random splits to consider for each
candidate splitting variable in the \code{"extratrees"} rule.}

\item{alpha}{significance threshold to allow splitting in the
\code{"maxstat"} rule.}

\item{minprop}{lower quantile of covariate distribution to be considered for
splitting in the \code{"maxstat"} rule.}

\item{split.select.weights}{numeric vector with weights between 0 and 1,
representing the probability to select variables for splitting.}

\item{always.split.variables}{character vector with variable names to be
always selected in addition to the \code{mtry} variables tried for
splitting.}

\item{respect.unordered.factors}{handling of unordered factor covariates.}

\item{scale.permutation.importance}{scale permutation importance by
standard error.}

\item{verbose}{show computation status and estimated runtime.}
}
\value{
\code{MLModel} class object.
}
\description{
Fast implementation of random forests or recursive partitioning.
}
\details{
\describe{
  \item{Response types:}{\code{factor}, \code{numeric}, \code{Surv}}
  \item{\link[=TunedModel]{Automatic tuning} of grid parameters:}{
    \code{mtry}, \code{min.node.size}*, \code{splitrule}*
  }
}
* excluded from grids by default

Default values and further model details can be found in the source link
below.
}
\examples{
\donttest{
## Requires prior installation of suggested package ranger to run

fit(Species ~ ., data = iris, model = RangerModel)
}

}
\seealso{
\code{\link[ranger]{ranger}}, \code{\link{fit}},
\code{\link{resample}}
}
