% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_SelectedModel.R
\name{SelectedModel}
\alias{SelectedModel}
\title{Selected Model}
\usage{
SelectedModel(..., control = CVControl, metrics = NULL,
  stat = base::mean, cutoff = NULL)
}
\arguments{
\item{...}{\code{MLModel} functions, function names, objects, or lists of
these to serve as the candidate set from which to select.}

\item{control}{\code{\link{MLControl}} object, control function, or character
string naming a control function defining the resampling method to be
employed.}

\item{metrics}{function, one or more function names, or list of named
functions representing performance metrics to be calculated.  If not
specified, default metrics defined in the \code{\link{performance}}
functions are used.  Model selection is based on the first calculated metric.}

\item{stat}{function to compute a summary statistic on resampled values of
the metric for model selection.}

\item{cutoff}{argument passed to the \code{metrics} functions.}
}
\value{
\code{SelectedModel} class object that inherits from \code{MLModel}.
}
\description{
Model selected from a candidate set, as produced by the \code{\link{tune}}
function.
}
\details{
\describe{
\item{Response Types:}{\code{factor}, \code{numeric}, \code{ordered},
\code{Surv}
}
}
}
\examples{
fit(sale_amount ~ ., data = ICHomes,
    model = SelectedModel(GBMModel, GLMNetModel, SVMRadialModel))

}
\seealso{
\code{\link{tune}}, \code{\link{fit}}, \code{\link{resample}}
}
