% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelmetrics.R
\name{modelmetrics}
\alias{modelmetrics}
\alias{modelmetrics.Resamples}
\alias{modelmetrics.factor}
\alias{modelmetrics.matrix}
\alias{modelmetrics.numeric}
\alias{modelmetrics.Surv}
\title{Model Performance Metrics}
\usage{
modelmetrics(x, ...)

\method{modelmetrics}{Resamples}(x, ..., na.rm = TRUE)

\method{modelmetrics}{factor}(x, y, metrics = c(Accuracy =
  MachineShop::accuracy, Kappa = MachineShop::kappa2, ROCAUC =
  MachineShop::roc_auc, Sensitivity = MachineShop::sensitivity, Specificity
  = MachineShop::specificity, Brier = MachineShop::brier), cutoff = 0.5,
  ...)

\method{modelmetrics}{matrix}(x, y, metrics = c(R2 = MachineShop::r2,
  RMSE = MachineShop::rmse, MAE = MachineShop::mae), ...)

\method{modelmetrics}{numeric}(x, y, metrics = c(R2 = MachineShop::r2,
  RMSE = MachineShop::rmse, MAE = MachineShop::mae), ...)

\method{modelmetrics}{Surv}(x, y, metrics = c(CIndex =
  MachineShop::cindex, ROC = MachineShop::roc_auc, Brier =
  MachineShop::brier), times = numeric(), ...)
}
\arguments{
\item{x}{observed responses or class containing observed and predicted
responses.}

\item{...}{arguments passed from the \code{Resamples} method to the others.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating model metrics.}

\item{y}{predicted responses.}

\item{metrics}{function, one or more function names, or list of named
functions to include in the calculation of performance metrics.}

\item{cutoff}{threshold above which probabilities are classified as success
for binary responses.}

\item{times}{numeric vector of follow-up times at which survival events
were predicted.}
}
\description{
Compute measures of model performance.
}
\examples{
res <- resample(Species ~ ., data = iris, model = GBMModel)
(metrics <- modelmetrics(res))
summary(metrics)
plot(metrics)

## Survival response example
library(survival)
library(MASS)

fo <- Surv(time, status != 2) ~ sex + age + year + thickness + ulcer
gbmfit <- fit(fo, data = Melanoma, model = GBMModel)

obs <- response(fo, data = Melanoma)
pred <- predict(gbmfit, newdata = Melanoma, type = "prob")
modelmetrics(obs, pred)

}
\seealso{
\code{\link{response}}, \code{\link{predict}},
\code{\link{resample}}, \code{\link{metrics}}
}
