% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{MLControl-class}
\alias{MLControl-class}
\alias{initialize,MLControl-method}
\alias{BootControl}
\alias{CVControl}
\alias{OOBControl}
\alias{SplitControl}
\alias{TrainControl}
\title{Resampling Classes and Methods}
\usage{
\S4method{initialize}{MLControl}(.Object, summary = modelmetrics,
  cutoff = 0.5, cutoff_index = function(sens, spec) sens + spec,
  surv_times = numeric(), na.rm = TRUE, seed = NULL, ...)

BootControl(samples = 25, ...)

CVControl(folds = 10, repeats = 1, ...)

OOBControl(samples = 25, ...)

SplitControl(prop = 2/3, ...)

TrainControl(...)
}
\arguments{
\item{.Object}{class object being initialized.}

\item{summary}{function to compute model performance metrics.}

\item{cutoff}{threshold above which probabilities are classified as success
for factor outcomes and which expected values are rounded for integer
outcomes.}

\item{cutoff_index}{function to calculate a desired sensitivity-specificity
tradeoff.}

\item{surv_times}{numeric vector of follow-up times at which to predict
survival events.}

\item{na.rm}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating model metrics.}

\item{seed}{integer to set the seed at the start of resampling.  This is set
to a random integer by default (NULL).}

\item{...}{arguments to be passed to or from other methods.}

\item{samples}{number of bootstrap samples.}

\item{folds}{number of cross-validation folds (K).}

\item{repeats}{number of repeats of the K-fold partitioning.}

\item{prop}{proportion of cases to include in the training set
(\code{0 < prop < 1}).}
}
\value{
MLControl class object.
}
\description{
Resampling Classes and Methods

The base MLControl constructor initializes a set of parameters that are common
to all resampling methods.

\code{BootControl} constructs an MLControl object for simple bootstrap
resampling in which models are fit with bootstrap resampled training sets and
used to predict the full data set.

\code{CVControl} constructs an MLControl object for repeated K-fold
cross-validation.  In this procedure, the full data set is repeatedly
partitioned into K-folds.  Within a partitioning, prediction is performed on each
of the K folds with models fit on all remaining folds.

\code{OOBControl} constructs an MLControl object for out-of-bootstrap
resampling in which models are fit with bootstrap resampled training sets and
used to predict the unsampled cases.

\code{SplitControl} constructs an MLControl object for splitting data into a
seperate trianing and test set.

\code{TrainControl} constructs an MLControl object for training and
performance evaluation to be performed on the same training set.
}
\section{Slots}{

\describe{
\item{\code{summary}}{function to compute model performance metrics.}

\item{\code{cutoff}}{threshold above which probabilities are classified as success
for factor outcomes and which expected values are rounded for integer
outcomes.}

\item{\code{cutoff_index}}{function to calculate a desired sensitivity-specificity
tradeoff.}

\item{\code{surv_times}}{numeric vector of follow-up times at which to predict
survival events.}

\item{\code{na.rm}}{logical indicating whether to remove observed or predicted
responses that are \code{NA} when calculating model metrics.}

\item{\code{seed}}{integer to set the seed at the start of resampling.}
}}

\examples{
## 100 bootstrap samples
BootControl(samples = 100)

## 5 repeats of 10-fold cross-validation
CVControl(folds = 10, repeats = 5)

## 100 out-of-bootstrap samples
OOBControl(samples = 100)

## Split sample of 2/3 training and 1/3 testing
SplitControl(prop = 2/3)

## Same training and test set
TrainControl()

}
\seealso{
\code{\link{resample}}, \code{\link{modelmetrics}}
}
