% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict}
\alias{predict}
\alias{predict.MLModelFit}
\title{Model Prediction}
\usage{
\method{predict}{MLModelFit}(object, newdata = NULL,
  type = c("response", "prob"), cutoff = 0.5, times = numeric(), ...)
}
\arguments{
\item{object}{MLModelFit object from a model fit.}

\item{newdata}{optional data frame with which to obtain predictions.  If not
specified, the training data will be used by default.}

\item{type}{specifies prediction on the original outcome scale
(\code{"response"}) or on a probability distribution scale (\code{"prob"}).}

\item{cutoff}{threshold above which probabilities are classified as success
for factor outcomes and which expected values are rounded for integer
outcomes.}

\item{times}{numeric vector of follow-up times at which to predict
survival events.}

\item{...}{arguments passed to model-specific prediction functions.}
}
\description{
Predict outcomes with a fitted model.
}
\examples{
## Survival response example
library(survival)
library(MASS)

gbmfit <- fit(Surv(time, status != 2) ~ sex + age + year + thickness + ulcer,
              data = Melanoma, model = GBMModel)
predict(gbmfit, newdata = Melanoma, times = 365 * c(2, 5, 10), type = "prob")

}
\seealso{
\code{\link{fit}}, \code{\link{modelmetrics}}
}
