% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMAES_steady.R
\name{SMOCMAES}
\alias{SMOCMAES}
\title{Steady-state Multi-Objective CMA-ES}
\usage{
SMOCMAES(parent, nObjective, fun, control = list(), ...)
}
\arguments{
\item{parent}{The parent generation, an object of class cmaes_gen. The MO-CMA-ES parent is a 5 tuple: x (the design point, length = number of variable),averageSuccessRate (scalar),stepSize (scalar), evoPath (evolution path, vector, length = number of variable ),covarianceMatrix (square matrix with ncol = nrow = number of variable). The parent is then should be a vector of lists (see example).}

\item{nObjective}{The number of objective functions. A scalar value.}

\item{fun}{Objective function being solved.}

\item{control}{List of parameters for CMA-ES. Available control are as follows:
\code{successProbTarget} Target success probability
\code{successProbThreshold} The threshold for success probability. If the average success probability is higher than this value, the success rate growth is slowed.
\code{crossoverProbability} The probability of doing crossover. Should be between 0-1. Negative value will behave like a zero, and values larger than 1 will behave like 1. Default to 1.
\code{crossoverDistribution} The distribution index for SBX. Larger index makes the distribution sharper around each parent.}

\item{...}{Further arguments to be passed to \code{fun}}
}
\value{
Returns a list for the next generation. It contains list$new_generation (class: cmaes_gen), list$population (basically a copy of list$new_generation[[]]$x), and list$populationObjective
}
\description{
Do an iteration of population based steady state Multi-Objective Covariance Matrix Adaptation Evolution Strategy (MO-CMA-ES). The variation is using simulated binary crossover (SBX) and mutation following the CMA. The original MO-CMA-ES does not use crossover, to do this simply set crossoverProbability to zero.
}
\examples{
 \donttest{
nVar <- 14
nObjective <- 5
nIndividual <- 100
crossoverProbability <- 1
ps_target <- 1 / (5 + ( 1 / 2  ) )
pop <- matrix(stats::runif(nIndividual*nVar), nrow = nVar) # create the population
a_list <- cmaes_gen(pop)
control <- list(successProbTarget=ps_target,crossoverProbability=crossoverProbability)
# run a generation of SMO-CMA-ES with standard WFG8 test function.
newGeneration <- SMOCMAES(a_list,nObjective,WFG8,control,nObjective)
}
}
\references{
Voß, T., Hansen, N., Igel, C.: Improved step size adaptation for the MO-CMA-ES. In: Genetic and Evolutionary Computation (GECCO). pp. 487–494. ACM, New York, NY (2010)
}
