% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2side.R
\name{dmwright2}
\alias{dmwright2}
\title{Two-sided M-Wright distribution}
\usage{
dmwright2(ah, sh, m, max)
}
\arguments{
\item{ah}{point estimate for shape parameter alpha.}

\item{sh}{point estimate for scale parameter s.}

\item{m}{number of data points (pairs) to use for plotting.}

\item{max}{maximum  x-axis value to use for plotting.}
}
\value{
numeric matrix
}
\description{
Plots the density function.
}
\examples{

xy=dmwright2(0.45, 2.5, 1000, 10)
plot(xy[,1], xy[,2],  lwd = 2, type="l",ylab="", xlab="x")

mwright2_sided <- rmwright2(1000, 0.45, 2.5)
hist(mwright2_sided, br=30, prob=TRUE)
lines(xy[,1], xy[,2],  lwd=2 )



}
\references{
Cahoy and Minkabo (2017). \emph{Inference for three-parameter M-Wright distributions with applications.} Model Assisted Statistics and Applications, 12(2), 115-125.
\url{https://doi.org/10.3233/MAS-170388}

Cahoy (2012). \emph{Moment estimators for the two-parameter M-Wright distribution.} Computational Statistics, 27(3), 487-497.
\url{https://doi.org/10.1007/s00180-011-0269-x}

Cahoy (2012). \emph{Estimation and simulation for the M-Wright function.}  Computational Statistics, 27(3), 487-497.
\url{https://doi.org/10.1080/03610926.2010.543299}

Cahoy (2011). \emph{On the parameterization of the M-Wright function.} Far East Journal of Theoretical Statistics, 34(2), 155-164.
\url{http://www.pphmj.com/abstract/5767.htm}

Mainardi, Mura, and Pagnini (2010). \emph{The M-Wright Function in Time-Fractional Diffusion Processes: A Tutorial Survey}. Int. J. Differ. Equ., Volume 2010.
\url{https://doi.org/10.1155/2010/104505}
}
