% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneSampleHT2.R
\name{OneSampleHT2}
\alias{OneSampleHT2}
\title{One Sample Hotelling T^2 Test}
\usage{
OneSampleHT2(data, mu0, alpha = 0.05)
}
\arguments{
\item{data}{a data frame.}

\item{mu0}{mean vector that is used to test whether population mean 
parameter is equal to it.}

\item{alpha}{Significance Level that will be used for confidence intervals.
\code{default alpha=0.05}.}
}
\value{
a list with 7 elements:
\item{HT2}{The value of Hotelling T^2 Test Statistic}
\item{F}{The value of F Statistic}
\item{df}{The F statistic's degree of freedom}
\item{p.value}{p value}
\item{CI}{The lower and upper limits of confidence intervals obtained 
for all variables}
\item{alpha}{The alpha value using in confidence intervals}
\item{Descriptive}{Descriptive Statistics}
}
\description{
\code{OneSampleHT2} computes one sample Hotelling T^2 statistics and gives
confidence intervals
}
\details{
This function computes one sample Hotelling T^2 statistics that is used to 
test whether population mean vector is equal to a vector given by a user.
When \code{H0} is rejected, this function computes confidence intervals
for all variables.
}
\examples{
data(iris)

mean0<-c(6,3,1,0.25)
result <- OneSampleHT2(data=iris[1:50,-5],mu0=mean0,alpha=0.05)
summary(result)
}
\references{
Rencher, A. C. (2003). Methods of multivariate analysis 
(Vol. 492). John Wiley & Sons.

Tatlidil, H. (1996). Uygulamali Cok Degiskenli Istatistiksel 
Yontemler. Cem Web.
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
