% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/royston.R
\name{royston}
\alias{royston}
\title{Royston's Multivariate Normality Test}
\usage{
royston(data, tol = 1e-25, bootstrap = FALSE, B = 1000, cores = 1)
}
\arguments{
\item{data}{A numeric matrix or data frame with observations in rows and variables in columns.}

\item{tol}{Numeric tolerance passed to \code{\link[base]{solve}} when inverting the covariance matrix. Default is \code{1e-25}.}

\item{bootstrap}{Logical; if \code{TRUE}, compute p-value via bootstrap
resampling. Default is \code{FALSE}.}

\item{B}{Integer; number of bootstrap replicates used when
\code{bootstrap = TRUE}. Default is \code{1000}.}

\item{cores}{Integer; number of cores for parallel computation when
\code{bootstrap = TRUE}. Default is 1.}
}
\value{
A data frame with one row containing the test name (\code{Test}), the Royston test statistic (\code{Statistic}),
and the associated p-value (\code{p.value}) from a chi-square approximation.
}
\description{
Performs Royston’s test for multivariate normality by combining univariate W-statistics
(Shapiro–Wilk or Shapiro–Francia) across variables and adjusting for the correlation structure.
}
\examples{
\dontrun{
data <- iris[1:50, 1:4]
royston_result <- royston(data)
royston_result
}

}
