% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mvn.R
\name{plot.mvn}
\alias{plot.mvn}
\title{Plot Diagnostics for Multivariate Normality Analysis}
\usage{
\method{plot}{mvn}(x, ...)
}
\arguments{
\item{x}{An object of class \code{mvn}, as returned by the \code{\link{mvn}} function.}

\item{...}{Additional arguments passed to internal plotting functions:
\code{diagnostic} (\code{"multivariate"}, \code{"univariate"}, \code{"outlier"}),
\code{type} (e.g., \code{"qq"}, \code{"boxplot"}, \code{"persp"}),
\code{interactive} (logical; use \pkg{plotly}), and}
}
\value{
This function is called for its side effect of producing plots. It does not return a value.
}
\description{
Generates diagnostic plots for objects of class \code{mvn}, including multivariate Q-Q plots,
3D or contour kernel density plots, univariate plots (e.g., Q-Q, histograms, boxplots),
and multivariate outlier detection plots. If a grouping variable (subset) was used in the
\code{\link{mvn}} function, plots will be generated separately for each group.
}
\examples{
\dontrun{
data <- iris[1:4]
result <- mvn(data)

plot(result, diagnostic = "multivariate", type = "qq")
plot(result, diagnostic = "univariate", type = "boxplot")
plot(result, diagnostic = "outlier")
}

}
