% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTAFT_CV.R
\name{MTAFT_CV}
\alias{MTAFT_CV}
\title{MTAFT_CV: Cross-Validation for Multiple Thresholds Accelerated Failure Time Model}
\usage{
MTAFT_CV(
  Y,
  X,
  delta,
  Tq,
  algorithm,
  dist_min = 50,
  ncps_max = 4,
  wbs_nintervals = 200
)
}
\arguments{
\item{Y}{the censored logarithm of the failure time.}

\item{X}{the design matrix without the intercept.}

\item{delta}{the censoring indicator.}

\item{Tq}{the threshold values.}

\item{algorithm}{the threshold detection algorithm, either "WBS" or "DP".}

\item{dist_min}{the pre-specified minimal number of observations within each subgroup. Default is 50.}

\item{ncps_max}{the pre-specified maximum number of thresholds. Default is 4.}

\item{wbs_nintervals}{the number of random intervals in the WBS algorithm. Default is 200.}
}
\value{
A list with the following components:
\describe{
  \item{params}{the subgroup-specific slope estimates and variance estimates.}
  \item{thres}{the threshold estimates.}
  \item{CV_vals}{the CV values for all candidate number of thresholds.}
}
}
\description{
This function implements a cross-validation method for the multiple thresholds accelerated
failure time (AFT) model using either the "WBS" (Wild Binary Segmentation) or "DP"
(Dynamic Programming) algorithm. It determines the optimal number of thresholds by
evaluating the cross-validation (CV) values.
}
\examples{
# Generate simulated data with 500 samples and normal error distribution
dataset <- MTAFT_simdata(n = 500, err = "normal")
\donttest{
Y <- dataset[, 1]
delta <- dataset[, 2]
Tq <- dataset[, 3]
X <- dataset[, -c(1:3)]

# Run mAFT_CV with WBS algorithm
maft_cv_result <- MTAFT_CV(Y, X, delta, Tq, algorithm = "WBS")
maft_cv_result$params
maft_cv_result$thres
maft_cv_result$CV_vals
}
}
