% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_Functions.R
\name{TAC}
\alias{TAC}
\title{Calculate TAC recommendations for more than one MP}
\usage{
TAC(Data, MPs = NA, reps = 100, timelimit = 1, checkMP = TRUE, silent = FALSE)
}
\arguments{
\item{Data}{A data-limited methods data object}

\item{MPs}{optional vector of MP names}

\item{reps}{Number of repetitions}

\item{timelimit}{The maximum time (seconds) taken to complete 10 reps}

\item{checkMP}{Logical. Check if the MP can be run first?}

\item{silent}{Logical. Suppress messages?}
}
\description{
A function that returns the stochastic TAC recommendations from a vector of
output control MPs given a data object Data
}
\examples{
\dontrun{
library(MSEtool)
Data <- TAC(MSEtool::Cobia)
plot(Data)
}
}
\author{
T. Carruthers
}
