% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetDist.R
\name{QDS}
\alias{QDS}
\title{Compute Quartet Distance Supertree}
\usage{
QDS(dqt, method = fastme.bal)
}
\arguments{
\item{dqt}{an (\code{n} choose 4) x \code{n} (or \code{n+1}) matrix of form output by \code{quartetTableDominant};
(Note: If present, the \code{n+1}th column of \code{dqt} is ignored)}

\item{method}{tree building function (e.g., fastme.bal, nj)}
}
\value{
an unrooted metric tree of type phylo. Edge lengths are not in interpretable units
}
\description{
Apply the Quartet Distance Supertree method of \insertCite{Rho19;textual}{MSCquartets} to a table specifying a
collection of quartets on \code{n} taxa.
}
\details{
This function is a wrapper which runs \code{quartetDist} and then builds a tree.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
DQT=quartetTableDominant(RQT)
tree=QDS(DQT)
write.tree(tree)
plot(tree)

}
\references{
\insertRef{Rho19}{MSCquartets}
}
\seealso{
\code{\link{quartetTableDominant}},
\code{\link{quartetDist}},
\code{\link{QDC}},
\code{\link{WQDS}}, 
\code{\link{WQDC}}, 
\code{\link{WQDCrecursive}}
}
