% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{predfreq}
\alias{predfreq}
\title{predfreq is used for modal analysis of count data}
\usage{
predfreq(pars, n, sizecl, midval = TRUE)
}
\arguments{
\item{pars}{a vector of parameters, with the means first,
followed by the standard deviations, followed by the
proportion of total observations in each cohort expect
the last, which is obtained through subtraction.}

\item{n}{the sum of counts observed from nature}

\item{sizecl}{a representation of the size-classes used, these 
can be the mid-points of each size-class or the lower and
upper bounds of each class.}

\item{midval}{if TRUE, the default, the approximate analytical
approach will be used.}
}
\value{
a vector of expected frequencies
}
\description{
predfreq is used to calculate the expected 
    frequencies (counts) from a series of Normal distributions
    that are combined to describe observed counts from a 
    sample of the size distribution of a population,
    which may, or may not be made up of a number of cohorts.
    When used with a negative log-likelihood from a
    multinomial this can lead to estimates of the mean and
    standard deviation of the size of each cohort. Two 
    approaches are possible. An approximate method that 
    calculates the likelihood at the center of each size-class
    and a more precise analytical method that subtracts the
    cumulative probability of the bottom bound from each size-
    class from the upper bound. Usually the two are very 
    close.
}
\examples{
\dontrun{
mids <- seq(6,56,2) #size classes = 2 mm as in 5-7, 7-9,...
av <- c(18.0,34.5)   # the means
stdev <- c(2.75,5.5)  # the standard deviations
prop1 <- 0.55  # the proportion of observations in cohort 1
pars <-c(av,stdev,prop1)  # combine parameters into a vector
predf <- predfreq(pars,n=262,sizecl=mids,midval=TRUE)
oldpar <- par(no.readonly=TRUE)
plot1(mids,predf,xlab="Sizes",ylab="Predicted Frequency",lwd=2)
par(oldpar)
}
}
