% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{likeratio}
\alias{likeratio}
\title{likeratio conducts a likelihood ratio test}
\usage{
likeratio(nLL1, nLL2, df = 1)
}
\arguments{
\item{nLL1}{the first -ve log-likelihood}

\item{nLL2}{the second -ve log-likelihood}

\item{df}{the number of degrees of freedom difference between the two
model, a minimum of 1, which is the default.}
}
\value{
a vector of the likelihood ratio, the significance of any 
    difference, the minimum difference required for significance, and
    the degrees of freedom.
}
\description{
likeratio conducts a likelihood ratio test on two
    negative log-likelihoods. It produces the LR plus related 
    statistics detailing if a significant difference has been found.
    The order in which the log-likelihoods are entered does not 
    matter as that is checked for so a positive likelihood ratio
    is always generated.
}
\examples{
  one <- 291.1691
  two <- 277.0122
  dof <- 1
  round(likeratio(one,two,dof),8)  # LR = 28.3138
}
