% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{panel.cor}
\alias{panel.cor}
\title{panel.cor is a version of function given in the pairs help}
\usage{
panel.cor(x, y, digits = 3, ...)
}
\arguments{
\item{x}{the first variable - provided by pairs}

\item{y}{the second variable, provided by pairs, see examples}

\item{digits}{how many digits to use on the pairs plot for the 
correlations}

\item{...}{any other graphics parameters to be passed to pairs.}
}
\value{
this prints the correlations in a square of the pairs plot
}
\description{
panel.cor is a panel function modified from that 
    described in the help file for the pairs function from the 
    graphics package. This has been customized both to show that 
    one can make such customizations, and to enable this one to be
    used to calculate the correlations between the variables 
    included in a pairs plot.
}
\examples{
  dat <- matrix(rnorm(900,mean=5,sd=0.5),nrow=300,ncol=3)
  pairs(dat[,1:3],lower.panel=panel.smooth,  # all should be
        upper.panel=panel.cor,gap=0.25,lwd=2) #low correlations
}
