% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getOrderBIC}
\alias{getOrderBIC}
\title{Get order of sequence based on BIC value}
\usage{
getOrderBIC(seq)
}
\arguments{
\item{seq}{- A sequence whose order to be determined}
}
\value{
Returns nothing but prints order of given sequence according to BIC value
}
\description{
Takes a sequence as input and find BIC value for diffrent orders
}
\examples{
## Check a first order sequence
seq <- c(1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2,1,2)
getOrderBIC(seq)

## Check for second order sequence
seq <- c(1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2,1,1,2,2)
getOrderBIC(seq)

## Check for random order sequence
seq <- sample(1:2,50,replace=TRUE)
getOrderBIC(seq)
}
\references{
[1] Estimating the order of Markov chain Richard Katz Technometrics,
   vol 12 no 3 (August 1981) pp 243-249

[2] Determination of the Order of a Markov Chain L.C.Zhao, C.C.Y.Dorea and
   C.R.Goncalves Statistical inference for stochastic processes4, 2001 pp 273-282

[3] Statistical inference about Markov Chain T.W.Anderson and Leo.A.Goodman.
   The Annals of Mathematical Statistics, Vol 28, No 1 (March 1957), pp89-110
}

