% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.dep.t.rm.R
\name{d.dep.t.rm}
\alias{d.dep.t.rm}
\title{d for Repeated Measures with Average SD Denominator}
\usage{
d.dep.t.rm(m1, m2, sd1, sd2, r, n, a = 0.05)
}
\arguments{
\item{m1}{mean from first level}

\item{m2}{mean from second level}

\item{sd1}{standard deviation from first level}

\item{sd2}{standard deviation from second level}

\item{r}{correlation between first and second level}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
Controls for correlation and provides the effect size (Cohen's d)
with associated confidence intervals,m the confidence intervals associated
with the means of each group,mstandard deviations and standard errors of
the means for each group.

\item{d}{effect size}
\item{dlow}{lower level confidence interval d value}
\item{dhigh}{upper level confidence interval d value}
\item{M1}{mean one}
\item{sd1}{standard deviation of mean one}
\item{se1}{standard error of mean one}
\item{M1low}{lower level confidence interval of mean one}
\item{M1high}{upper level confidence interval of mean one}
\item{M2}{mean two}
\item{sd2}{standard deviation of mean two}
\item{se2}{standard error of mean two}
\item{M2low}{lower level confidence interval of mean two}
\item{M2high}{upper level confidence interval of mean two}
\item{r}{correlation}
\item{n}{sample size}
\item{df}{degrees of freedom (sample size - 1)}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
}
\description{
This function displays d and the non-central confidence interval
for repeated measures data, using the average standard deviation of
each level as the denominator, but controlling for r.
}
\details{
To calculate d, mean two is subtracted from mean one, which is
divided by the average standard deviation, while mathematically
controlling for the correlation coefficient (r).

d_rm = ((m1 - m2) / sqrt(( sd1^2 + sd2^2 ) - (2 x r x sd1 x sd2))) x sqrt(2 x (1-r))

\href{https://www.aggieerin.com/shiny-server/tests/deptrm.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "dept_data" dataset included
#in the MOTE library.

#In a study to test the effects of science fiction movies on people's
#belief in the supernatural, seven people completed a measure of belief
#in the supernatural before and after watching a popular science fiction
#movie. Higher scores indicated higher levels of belief.

    t.test(dept_data$before, dept_data$after, paired = TRUE)

    scifi_cor = cor(dept_data$before, dept_data$after, method = "pearson",
                use = "pairwise.complete.obs")

#You can type in the numbers directly, or refer to the dataset,
#as shown below.

    d.dep.t.rm(m1 = 5.57, m2 = 4.43, sd1 = 1.99,
                sd2 = 2.88, r = .68, n = 7, a = .05)

    d.dep.t.rm(5.57, 4.43, 1.99, 2.88, .68, 7, .05)

    d.dep.t.rm(mean(dept_data$before), mean(dept_data$after),
                sd(dept_data$before), sd(dept_data$after),
                scifi_cor, length(dept_data$before), .05)

#The mean measure of belief on the pretest was 5.57, with a standard
#deviation of 1.99. The posttest scores appeared lower (M = 4.43, SD = 2.88)
#but the dependent t-test was not significant using alpha = .05,
#t(7) = 1.43, p = .203, d_rm = 0.43. The effect size was a medium effect suggesting
#that the movie may have influenced belief in the supernatural.

}
\keyword{cohen's}
\keyword{correlation}
\keyword{d,}
\keyword{dependent}
\keyword{effect}
\keyword{measures,}
\keyword{paired-sample,}
\keyword{repeated}
\keyword{size,}
\keyword{t-test,}
