% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runGdal.R
\name{runGdal}
\alias{runGdal}
\title{Process MODIS HDF with GDAL}
\usage{
runGdal(
  product,
  collection = NULL,
  begin = NULL,
  end = NULL,
  extent,
  tileH,
  tileV,
  SDSstring = NULL,
  job = NULL,
  checkIntegrity = TRUE,
  forceDownload = TRUE,
  overwrite = FALSE,
  maskValue = NULL,
  ...
)
}
\arguments{
\item{product}{\code{character}, see \code{\link[=getProduct]{getProduct()}}.}

\item{collection}{\code{character} or \code{integer}, see \code{\link[=getCollection]{getCollection()}}.}

\item{begin, end}{\code{Date} or \code{character}. Begin and end date of MODIS time
series, see \code{\link[=transDate]{transDate()}}.}

\item{extent}{Extent information, defaults to 'global'. See \code{\link[=getTile]{getTile()}}.}

\item{tileH, tileV}{\code{numeric} or \code{character}. Horizontal and vertical tile
number, see \code{\link[=getTile]{getTile()}}.}

\item{SDSstring}{\code{character}, see \code{\link[=getSds]{getSds()}}.}

\item{job}{\code{character}. Name of the current job for the creation of the
output folder. If not specified, it is created in
'PRODUCT.COLLECTION_DATETIME'.}

\item{checkIntegrity, forceDownload}{\code{logical}, see \code{\link[=getHdf]{getHdf()}}.}

\item{overwrite}{\code{logical}, defaults to \code{FALSE}. Determines whether or not to
overwrite existing SDS output files.}

\item{maskValue}{If \code{NULL} (default), i.e. not explicitly set, the per-band
\verb{NoData Value} is taken into account. If not \code{NULL}, a vector of masking
values with each value corresponding to a single band in 'SDSstring'. This
can include \code{"None"} to ignore intrinsic no-data settings on the source
data set. See also
\url{https://gdal.org/programs/gdalwarp.html#cmdoption-gdalwarp-srcnodata} for
details.}

\item{...}{Additional arguments passed to \code{\link[=MODISoptions]{MODISoptions()}}, e.g. 'wait'.
Permanent settings for these arguments are temporarily overridden.}
}
\value{
A \code{list} of the same length as 'product'. Each product slot either holds a
sub-\code{list} of processed dates which, for each time step, includes the
corresponding output files as \code{character} objects or, if no files could be
found for the specified time period, a single \code{NA}.
}
\description{
Downloads MODIS grid files from archive (HTTP or local) and processes them.
}
\details{
\itemize{
\item \verb{outProj, pixelSize, resamplingType, dataFormat, localArcPath, outDirPath}:
See \code{\link[=MODISoptions]{MODISoptions()}}.
\item \code{blockSize}: integer. If \code{NULL} (default), the stripe size is set by GDAL.
Basically it is the \verb{-co BLOCKYSIZE=} parameter. See
\url{https://gdal.org/frmt_gtiff.html}.
\item \code{compression} logical. If \code{TRUE} (default), compress data with the lossless
LZW compression with \code{predictor=2}. See \url{https://gdal.org/frmt_gtiff.html}.
}

\code{\link[=runGdal]{runGdal()}} uses numerous \strong{MODIS} functions under the hood, see the linked
functions in Arguments for details and inputs.

If 'extent' is a \verb{Raster*} object, the output has exactly the same extent,
pixel size, and projection.
If 'extent' is a \strong{sp} or \strong{sf} object, the output has exactly the same
extent and projection except for point geometries with length 1 (i.e. a
single point) where only the projection is inherited.
If 'tileH' and 'tileV' are used (instead of 'extent') to define the area of
interest, and 'outProj' and 'pixelSize' are \code{"asIn"}, the result is only
converted from multi-layer HDF to 'dataFormat', default \code{"GTiff"}.
}
\examples{
\dontrun{
# LST in Austria
runGdal( product="MOD11A1", extent="austria", begin="2010001", end="2010005", SDSstring="101")

# LST with interactive tile selection
runGdal( product="MOD11A1", begin="2010001", end="2010005", SDSstring="101")

### outProj examples
# LST of Austria warped to UTM 34N (the three different possibilites to specify "outProj")
# to find am EPSG or prj4 you may use: prj <- make_EPSG() See  
runGdal( job="LSTaustria", product="MOD11A1", extent="Austria", begin="2010001", end="2010005",
         SDSstring="101", outProj="EPSG:32634")

runGdal( job="LSTaustria", product="MOD11A1", extent="Austria", begin="2010001", end="2010005",
         SDSstring="101", outProj=32634)

runGdal( job="LSTaustria", product="MOD11A1", extent="Austria", begin="2010001", end="2010005",
         SDSstring="101", outProj="+proj=utm +zone=34 +ellps=WGS84 +datum=WGS84 +units=m +no_defs")

### resamplingType examples
runGdal( job="LSTaustria", product="MOD11A1", extent="Austria", begin="2010001", end="2010005",
         SDSstring="1", resamplingType="lanczos", outProj="32634", pixelSize=100)

### processing entire tiles and keeping Sinusoidal projection
# This corresponds to a format conversion (eos-hdf04 to Geotiff) and 
# layer extraction (multi-layer to single layer)
runGdal( job="LSTaustria", product="MOD11A1", tileH=18:19,tileV=4, begin="2010001", end="2010005",
         SDSstring="1", outProj="asIn")

}

}
\seealso{
\code{\link[=getHdf]{getHdf()}}, \code{\link[=runMrt]{runMrt()}}.
}
\author{
Matteo Mattiuzzi, Florian Detsch
}
