% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orgTime.R
\name{orgTime}
\alias{orgTime}
\alias{orgTime,character-method}
\alias{orgTime,Date-method}
\alias{orgTime,Raster-method}
\title{Handle Input and Output Dates Used for Filtering}
\usage{
\S4method{orgTime}{character}(
  files,
  nDays = "asIn",
  begin = NULL,
  end = NULL,
  pillow = 75,
  pos1,
  pos2,
  format = "\%Y\%j"
)

\S4method{orgTime}{Date}(files, nDays = "asIn", begin = NULL, end = NULL, pillow = 75)

\S4method{orgTime}{Raster}(
  files,
  nDays = "asIn",
  begin = NULL,
  end = NULL,
  pillow = 75,
  pos1,
  pos2,
  format = "\%Y\%j"
)
}
\arguments{
\item{files}{A \code{character}, \code{Date}, or \verb{Raster*} object. Typically MODIS file
names created e.g. from \code{\link[=runGdal]{runGdal()}} or \code{\link[=runMrt]{runMrt()}}, but any other file names
holding date information are supported as well. If a \verb{Raster*} object is
supplied, make sure to adjust 'pos1', 'pos2', and 'format' according to its
layer \code{\link[raster:names]{raster::names()}}.}

\item{nDays}{Time interval for output layers. Defaults to \code{"asIn"} that
includes the exact input dates within the period selected using 'begin' and
'end'. Can also be \code{"1 month"} or \code{"1 week"}, see \code{\link[=seq.Date]{seq.Date()}} and
Examples.}

\item{begin}{\code{character}. Output begin date, defaults to the earliest input
data set.}

\item{end}{\code{character}. Output end date, defaults to the latest input data
set. Note that the exact end date depends on 'begin' and 'nDays'.}

\item{pillow}{\code{integer}. Number of days added to the beginning and end of a
time series.}

\item{pos1, pos2, format}{Arguments passed to \code{\link[=extractDate]{extractDate()}}.}
}
\value{
A \code{list} with the following slots (to be completed):
\itemize{
\item $inSeq
\item $outSeq
\item $inDoys
\item $inputLayerDates
\item $outputLayerDates
\item $call
}
}
\description{
This function lets you define the period to be filtered, the output temporal
resolution, and select the required data from your input files.
}
\examples{
# Using MODIS files
files <- c("MOD13A2.A2010353.1_km_16_days_composite_day_of_the_year.tif",
           "MOD13A2.A2011001.1_km_16_days_composite_day_of_the_year.tif",
           "MYD13A2.A2010361.1_km_16_days_composite_day_of_the_year.tif",
           "MYD13A2.A2011009.1_km_16_days_composite_day_of_the_year.tif")

orgTime(files)
orgTime(files,nDays=2,begin="2010350",end="2011015")

# Using other files, e.g. from AVHRR GIMMS NDVI (Jul 1981 to Dec 1982)
\dontrun{
library(gimms)

files.v1 <- system.file("extdata/inventory_ecv1.rds", package = "gimms")
files.v1 <- readRDS(files.v1)[1:3]
dates.v1 <- monthlyIndices(files.v1, timestamp = TRUE)

orgTime(dates.v1)
}

}
\seealso{
\code{\link[=seq.Date]{seq.Date()}}.
}
\author{
Matteo Mattiuzzi, Florian Detsch
}
