% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAltTSS.R
\name{getAltTSS}
\alias{getAltTSS}
\title{Annotate Peaks falling in Transcription Start Sites
  (TSS) and identify alternatively regulated TSSs for each gene.}
\usage{
getAltTSS(
  completeDAPs,
  returnAllTSS = FALSE,
  nuancedTSS = TRUE,
  nuancedTSSGap = 150,
  threshold = 0.2,
  TxDb,
  OrgDb
)
}
\arguments{
\item{completeDAPs}{GRanges object that contains the differential
measurements across all peaks (unfiltered DAPs). Will also work with
data.frame or data.table version of a GRanges object. If you want
alternatively regulated TSSs, the object must include a column names 'FDR',
and 'Log2FC_C', which is standard for MOCHA differentials.}

\item{returnAllTSS}{Flag to return all TSSs with DAPs measurements,
without filtering for alternative TSS usage. If multiple TSSs fall within
the same tile, then that tile will be repeated for each TSS.}

\item{nuancedTSS}{True/False flag to determine if alternative TSS genes
should be filtered out if all their differential TSS usage falls within too
small of a range. Default is TRUE}

\item{nuancedTSSGap}{Minimum distance betweeen TSSs needed for them to
considered distinctly regulated TSSs. If two TSSs are too close, it is
unclear and highly unlikely that ATAC data can distinguish between them.
Default is 150 bp.}

\item{threshold}{FDR Threshold for determining significant vs non-significant
changes in accessibility. Following MOCHA's standards, default is 0.2.}

\item{TxDb}{The TxDb-class transcript annotation
package for your organism (e.g. "TxDb.Hsapiens.UCSC.hg38.refGene"). This
must be installed. See
\href{https://bioconductor.org/packages/release/data/annotation/}{
Bioconductor AnnotationData Packages}.}

\item{OrgDb}{The OrgDb-class genome wide annotation
package for your organism (e.g. "org.Hs.eg.db"). This must be installed.
See \href{https://bioconductor.org/packages/release/data/annotation/}{
Bioconductor AnnotationData Packages}}
}
\value{
tpeaks A GRanges containing annotated peaks falling in TSS
}
\description{
\code{getAltTSS} Pulls out all peaks that fall in TSS,
  annotates them with the name of gene, and identifies genes that have
  evidence for alternatively regulated TSSs, including both type i (only some
  of the open TSSs for a gene are significantly more (or less) accessible),
  and type ii (multiple TSSs are significant different, with some being more
  accessible and others less). Alternatively, this function  will return all
  open TSSs with differential measurements if the returnAllTSS flag is set to
  TRUE.
}
