% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateTiles.R
\name{annotateTiles}
\alias{annotateTiles}
\title{\code{annotateTiles}}
\usage{
annotateTiles(Obj, TxDb = NULL, Org = NULL, promoterRegion = c(2000, 100))
}
\arguments{
\item{Obj}{A RangedSummarizedExperment generated from getSampleTileMatrix,
containing TxDb and Org in the metadata. This may also be a GRanges object.}

\item{TxDb}{The annotation package for TxDb object for your genome.
Optional, only required if Obj is a GRanges.}

\item{Org}{The genome-wide annotation for your organism.
Optional, only required if Obj is a GRanges.}

\item{promoterRegion}{Optional list containing the window size in basepairs
defining the promoter region. The format is (upstream, downstream).
Default is (2000, 100).}
}
\value{
Obj, the input data structure with added gene annotations (whether GRanges or SampleTileObj)
}
\description{
\code{annotateTiles} annotates a set of sample-tile matrices
  given with gene annotations. Details on TxDb and Org annotation packages
  and available annotations can be found at Bioconductor:
  https://bioconductor.org/packages/3.15/data/annotation/
}
\examples{
\dontrun{
library(TxDb.Hsapiens.UCSC.hg38.refGene)
library(org.Hs.eg.db) 
SampleTileMatricesAnnotated <- MOCHA::annotateTiles(
  SampleTileMatrices,
  TxDb = TxDb.Hsapiens.UCSC.hg38.refGene,
  Org = org.Hs.eg.db
)
}

}
