% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnl_fd2_ova.R
\name{mnl_fd2_ova}
\alias{mnl_fd2_ova}
\title{Multinomial First Differences Predictions For Two Values (Observed Value Approach)}
\usage{
mnl_fd2_ova(
  model,
  data,
  xvari,
  value1,
  value2,
  nsim = 1000,
  seed = "random",
  probs = c(0.025, 0.975)
)
}
\arguments{
\item{model}{the multinomial model, from a \code{\link{multinom}}()-function call (see the \code{\link{nnet}} package)}

\item{data}{the data with which the model was estimated}

\item{xvari}{the name of the variable that should be varied}

\item{value1}{first value for the difference}

\item{value2}{second value for the difference}

\item{nsim}{numbers of simulations}

\item{seed}{set a seed for replication purposes.}

\item{probs}{a vector with two numbers, defining the significance levels. Default to 5\% significance level: \code{c(0.025, 0.975)}}
}
\value{
The function returns a list with several elements. Most importantly the list includes the simulated draws `S`, the simulated predictions `P`, the first differences of the predictions `P_fd`, a data set for plotting `plotdata` the predicted probabilities, and one for the first differences `plotdata_fd`.
}
\description{
Multinomial First Differences Predictions For Two Values (Observed Value Approach)
}
\examples{
library(nnet)
library(MASS)

dataset <- data.frame(y = c(rep("a", 10), rep("b", 10), rep("c", 10)),
                      x1 = rnorm(30),
                      x2 = rnorm(30, mean = 1),
                      x3 = sample(1:10, 30, replace = TRUE))

mod <- multinom(y ~ x1 + x2 + x3, data = dataset, Hess = TRUE)

fdi1 <- mnl_fd2_ova(model = mod, data = dataset,
                    xvari = "x1",
                    value1 = min(dataset$x1), value2 = max(dataset$x1))


\donttest{
library(foreign)
library(nnet)
library(MASS)

ml <- read.dta("https://stats.idre.ucla.edu/stat/data/hsbdemo.dta")

ml$prog2 <- relevel(ml$prog, ref = "academic")
ml$female2 <- as.numeric(ml$female == "female")

mod1 <- multinom(prog2 ~ female2 + read + write + math + science,
                 Hess = TRUE, data = ml)

fd1 <- mnl_fd2_ova(model = mod1, data = ml,
                   xvari = "math",
                   value1 = min(ml$math), value2= max(ml$math),
                   nsim = 1000)
}

}
