% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{Recall}
\alias{Recall}
\title{Recall}
\usage{
Recall(y_true, y_pred, positive = NULL)
}
\arguments{
\item{y_true}{Ground truth (correct) 0-1 labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}

\item{positive}{An optional character string for the factor level that
corresponds to a "positive" result}
}
\value{
Recall
}
\description{
Compute the recall score.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
pred <- ifelse(logreg$fitted.values < 0.5, 0, 1)
Recall(y_pred = pred, y_true = mtcars$vs, positive = "0")
Recall(y_pred = pred, y_true = mtcars$vs, positive = "1")
}

