% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testFunction.R
\name{partialFtest}
\alias{partialFtest}
\title{Partial F-test}
\usage{
partialFtest(X, y, varToTest)
}
\arguments{
\item{X}{design matrix of size n*p}

\item{y}{response vector of length n}

\item{varToTest}{vector containing the index of the column of X to test}
}
\value{
a vector of the same length as varToTest containing the p-values of the test.
}
\description{
Perform a partial F-test
}
\details{
y = X * beta + epsilon

null hypothesis : beta[varToTest] = 0
alternative hypothesis : it exists an index k in varToTest such that beta[k] != 0

The test statistic is based on a full and a reduced model.
full : y = X * beta + epsilon
reduced : y = X * beta[-varToTest] + epsilon
}
\seealso{
\link{Ftest}
}
