\name{CWRES}
\alias{CWRES}
\alias{cwres_1}
\title{ Generate conditional weighted residual (CWRES) diagnostic plots as a pdf. }
\description{
  CWRES is a function to generate CWRES diagnostic plots following a successful NONMEM run. 
  It can be called as a standalone function following a successful NONMEM run to generate CWRES
  plots.  Plots are the same as those generated by PLOTR or via NONR.  
}
\usage{
CWRES(ProjectDir, b, dvname, exportas = 0, logtrans = 0, grp = NULL, grpnames = NULL, covplt, 
cont.cov = NULL, cat.cov = NULL, missing = -99, epilog = NULL)
}
\arguments{
  \item{ProjectDir}{System path to the directory containing the NONMEM control (*.ctl) streams.}
  \item{b}{Vector of control stream numbers to run in NONMEM. Should be numeric with no placeholder zeros to left of number, i.e., "1" not "001".
  Example: \code{b=c(1,2,5)}}
  \item{dvname}{Name of the dependent variable to use as a label for the diagnostic plots.}
  \item{exportas}{Flag to choose pdf (0) or png (1) output for plots with default being "0" for pdf output.}
  \item{logtrans}{Flag to log transform (1) or not (0) the NONMEM output variables DV, PRED, and IPRED with the default being 
  "0" to NOT transform the variables.}
  \item{grp}{Item in NONMEM datafile or output table file that can be used to condition plots generated by PLOTR. 
  Default value is NULL. Example: \code{grp=c("SEX")}}
  \item{grpnames}{Optional vector of names for \code{grp} item. Vector length must equal number of conditions in \code{grp}. 
  Default value is NULL. Example: \code{grpnames=c("Male","Female")}}
  \item{covplt}{Flag to generate (1) or not (0) covariate diagnostic plots with default value being "0" to not routinely 
  create covariate plots.}
  \item{cont.cov}{Vector of continuous covariate names. Names must match those used as column headers in \code{DataFile}.  Values
  are retrieved from \code{DataFile} so they do not need to be part of the NONMEM \$TABLE step. Default value is NULL.
  Example: \code{cont.cov=c("AGE","WT","CRCL")}}
  \item{cat.cov}{Vector of categorical covariate names. Names must match those used as column headers in \code{DataFile}.  Values
  are retrieved from \code{DataFile} so they do not need to be part of the NONMEM \$TABLE step. Default value is NULL.
  Example: \code{cat.cov=c("SEX","FOOD")}}
  \item{missing}{Numeric item that defines value used to represent missing items in the NONMEM data file. Default value is "-99".}
  \item{epilog}{Path to user-defined script that will be sourced at completion of NONMEM run. Default value is NULL.}
}
\references{ MIfuns package available from Metrum Institute website (\code{http://metruminstitute.org/}). }
\author{ Developed by Metrum Institute (Bill Knebel, Tim Bergsma, and others). }
\section{Warning }{ CWRES values for each observation are attached to NONMEM "*.TAB" file as part of this function.
 Multiple runs of this function on the same "*.TAB" file are likely to create errors.}
\seealso{ \code{\link{NONR}},\code{\link{PLOTR}},\code{\link{compute.cwres}} }
\examples{
}
\keyword{ manip }
