% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIIVsem-data.R
\docType{data}
\name{felson1979}
\alias{felson1979}
\title{Attractiveness and academic ability}
\format{A data frame with 209 rows and 7 variables}
\usage{
felson1979
}
\description{
This data comes from a study by Felson and Borhnstedt (1979)
of perceived attractiveness and academic ability in teenagers, 
sixth through ninth grade. The six variables are perception of 
academic ability (academic), perception of physical 
attractiveness (attract), grade point average (gpa),
height, weight, and a strangers' rating of attractiveness 
(rating).
}
\details{
\itemize{
  \item acad. 
  \item athl. 
  \item attract.
  \item gpa. 
  \item height. 
  \item weight. 
  \item rating. 
}
}
\examples{

\dontrun{
  model <-  '
	 acad    ~ gpa + attract
    attract ~ height + weight + rating + acad
  '
}


}
\references{
Felson, R.B. & Bohrnstedt, G.W. (1979). "Are the good 
  beautiful or the beautiful good?" The relationship between 
  children's perceptions of ability and perceptions of 
  physical attractiveness. Social Psychology Quarterly, 
  42, 386–392.
}
\keyword{datasets}
