% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mskOpt.R
\name{mskopt}
\alias{mskopt}
\title{Estimates of parameter corresponding to minimum AIC}
\usage{
mskopt(Dep, Id, Time, m, n, data)
}
\arguments{
\item{Dep}{column name of dependent variable in the dataset}

\item{Id}{column name of id of subjects in the dataset}

\item{Time}{column name of timepoints in the dataset}

\item{m}{starting column number of covariates}

\item{n}{ending column number of covariates}

\item{data}{balanced longitudinal data set where each subject's outcome has
 been measured at same time points and number of visits for each patient is same,
covariance structure of the outcome variable like "unstuctured","compound","ToE",
"AR1","markov","independence"}
}
\value{
estimated parameter value for multiple linear regression model for that covariance structure with minimum AIC value.
}
\description{
provides estimates of parameter of linear regression model of the
response variable corresponding to the minimum AIC value using mean score method with different covariance structure
}
\details{
It calculates the AIC value for the linear regression model
\deqn{Y_{ij}=\beta_0+\beta_1x_{1ij}+\beta_2 x_{2ij}+...+\beta_p x_{pij}+e_{ij}}
using mean score method with different covariance structures and gives the estimates of
parameter for minimum AIC value
}
\examples{
data(srdata)
mskopt(Dep="C6kine",Id="ID",Time="Visit",m=5,n=10,data=srdata)
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
