% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/byran.R
\name{byran}
\alias{byran}
\title{Bayesian analysis of non linear mean response model with random effect compound covariance
matrix}
\usage{
byran(m, n, n.chains, data)
}
\arguments{
\item{m}{starting column number}

\item{n}{ending column number}

\item{n.chains}{number of MCMC chains}

\item{data}{dataset with first row represents proportion,dimension have to be 9 by 11.}
}
\value{
posterior distribution result of parameters
}
\description{
Provides bayesian analysis of random effect model for repeated measurement data with missing values
using MCMC for compound symmetry covariance structure,where age follows normal distribution
}
\details{
The model for the response is \deqn{Y_{ij}=\beta_1+b_i+\beta_{2}exp(-\beta_{3}x_{ij})+e_{ij}}
,where \eqn{e_{ij}} are independent \eqn{ N(0,\sigma^2)} and independent of n random effects \eqn{b_i\sim N(0,\sigma_b^2)}
,where i refers to ith individual and j is the timepoint.
}
\examples{
##
data(propdata)
byran(m=1,n=4,n.chains=1,data=propdata)
##
}
\references{
Broemeling, Lyle D. Bayesian methods for repeated measures. CRC Press, 2015.
}
\author{
Atanu Bhattacharjee,Bhrigu Kumar Rajbongshi and Gajendra K Vishwakarma
}
