% Generated by roxygen2 (4.0.1): do not edit by hand
\name{MIICD.coxph}
\alias{MIICD.coxph}
\title{Cox regression for interval censored data using multiple imputation}
\usage{
MIICD.coxph(formula, k, m, data, method = c("PMDA", "ANDA"),
  verbose = FALSE)
}
\arguments{
\item{formula}{A formula. The right hand side indicates names of covariables to be found in \code{data}}

\item{method}{Which data augmentation scheme shall be used ? Two algorithms are implemented : \emph{The Poor man's Data Augmentation
scheme} and the \emph{Asymptotic Normal Data Augmentation scheme} (the later may be preferred).}

\item{verbose}{Logical, display the results ?}

\item{k}{An integer, indicates the number of iteration to perform}

\item{m}{An integer, indicates the number of imputation to perform at each iteration}

\item{data}{The input data (see details)}
}
\value{
\code{est} A data frame with estimates
}
\description{
Uses the multiple imputation approach to compute the regression coefficient and its associated
 variance-covariance matrix, and the baseline survival estimates of a Cox proportional hazards regression for interval censorded data
}
\details{


This function uses multiple imputation approach to estimate regression coefficient, its variance-covvariance
  matrix, and baseline survival estimates for a Cox proportional hazards regression for interval censorded data.

 Estimates are computed using Rubin's rules (Rubin (1987)). Estimate of coefficient is computed as the mean of estimates over imputation. #'  The variance-covariance matrix is computed as the within imputation variance and the between imputation variance augmented by an
 inflation factor to take into account the finite number of imputation. At each iteration, the baseline survival function is updated
 and multiple imputation is performed using updated estimates.

 Print and plot methods are available to handle results.

 The \code{data} must contain at last two columns: \code{left} and \code{right}. For interval censored data, the \code{left} and the
 \code{right} columns indicates lower and upper bounds of intervals respectively. \code{Inf} in the right column stands
 for right censored observations.
}
\examples{
res <- MIICD.coxph(formula = ~ treatment, k = 5, m = 5, data = bcos, verbose = FALSE)
 plot(res)
 #diagnostic plot for coefficients end associated standard error
 plot(res , type = 'coef' , coef = 1)
 plot(res , type = 'sigma' , coef = 1)
}
\author{
Marc Delord
}
\references{
Delord, M. & Genin, E. Multiple Imputation for Competing Risks Regression with Interval Censored Data Journal of Statistical
 Computation and Simulation, 2015

PAN, Wei. A Multiple Imputation Approach to Cox Regression with Interval-Censored Data. Biometrics, 2000, vol. 56, no 1,
  p. 199-203.

Rubin, D. B. (1987). Multiple imputation for nonresponse in surveys.

Schenker, N. and Welsh, A. (1988). Asymptotic results for multiple imputation. The Annals of Statistics pages 1550-1566.

Tanner, M. A. and Wong, W. H. (1987). An application of imputation to an estimation problem in grouped lifetime analysis.
 Technometrics 29, 23-32.

Wei, G. C., & Tanner, M. A. (1991). Applications of multiple imputation to the analysis of censored regression data.
 Biometrics, 47(4), 1297-1309.
}
\seealso{
\link[survival]{Surv}, \link[survival]{survfit}, \link[survival]{coxph}, \link[MASS]{mvrnorm}
}

