% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecFunctions_Final3.R
\name{simulate_many_poly_spectra}
\alias{simulate_many_poly_spectra}
\title{simulate_many_poly_spectra}
\usage{
simulate_many_poly_spectra(
  mono.info,
  nsim = 10000,
  file = NULL,
  mixture.ratio,
  mixture.missing.prob.peak = 0.05,
  noise.peak.ratio = 0.05,
  snr.basepeak = 500,
  noise.cv = 0.25,
  mz.range = c(1000, 2200),
  mz.tol = 0.5
)
}
\arguments{
\item{mono.info}{A list output of \code{\link{gather_summary}} or {\code{\link{gather_summary_file}}}.}

\item{nsim}{The number of simulated spectra. (Default: 10000)}

\item{file}{An output file name. (By default, file=NULL. No pdf file will be generated.)}

\item{mixture.ratio}{A list of bacterial mixture ratios for given bacterial species in sim.template.}

\item{mixture.missing.prob.peak}{A real value. The missing probability caused by mixing multiple bacteria species. (Default: 0.05)}

\item{noise.peak.ratio}{A ratio between the numbers of noise and signal peaks. (Default: 0.05)}

\item{snr.basepeak}{A (base peak) signal to noise ratio. (Default: 5000)}

\item{noise.cv}{A coefficient of variation of noise peaks. (Default: 0.25)}

\item{mz.range}{A range of m/z values. (Default: c(1000,2200))}

\item{mz.tol}{m/z tolerance. (Default: 0.5)}
}
\value{
A list of data frames. A list of simulated mass spectra (data frames) that contains m/z values of peaks, normalized intensities of peaks, species names, and strain names. This function also creates pdf files which contain simulated spectra.
}
\description{
The function creates simulated mass spectra in pdf file and returns simulated mass spectra (m/z and intensity values of peaks).
}
\examples{
spectra.processed.A <- process_monospectra(
   file=system.file("extdata", "listA.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.processed.B <- process_monospectra(
   file=system.file("extdata", "listB.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.processed.C <- process_monospectra(
   file=system.file("extdata", "listC.txt", package="MGMS2"),
   mass.range=c(1000,2200))
spectra.mono.summary.A <- summarize_monospectra(
   processed.obj=spectra.processed.A,
   species='A', directory=tempdir())
spectra.mono.summary.B <- summarize_monospectra(
   processed.obj=spectra.processed.B,
   species='B', directory=tempdir())
spectra.mono.summary.C <- summarize_monospectra(
   processed.obj=spectra.processed.C,
   species='C', directory=tempdir())
mono.info=gather_summary(c(spectra.mono.summary.A, spectra.mono.summary.B, spectra.mono.summary.C))
mixture.ratio <- list()
mixture.ratio['A']=1
mixture.ratio['B']=0.5
mixture.ratio['C']=0
insilico.spectra <- simulate_many_poly_spectra(mono.info, mixture.ratio=mixture.ratio, nsim=10)
}
