% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{meandist.from.truth}
\alias{meandist.from.truth}
\title{Calculates mean square distance between marker positions in two different maps.}
\usage{
meandist.from.truth(estmap, realmap)
}
\arguments{
\item{estmap}{Estimated map with 2 columns, \code{name} and \code{position} 
contain marker names and positions.}

\item{realmap}{Map in which the first column contains marker names and the 
second contains marker positions. Column names are not necessary.}
}
\value{
A list with the following elements:
\item{pointdist}{Data frame containing marker names and the distance between 
the estimated position and the "real" position.}
\item{meansquaredist}{mean square distance between the estimated real position 
of markers.}
}
\description{
Calculates mean square distance of markers in the analysis from some objective 
"truth".
}
\details{
The first column of \code{realmap} must contain identical entries to 
 \code{estmap$name}. However, the order of entries can be different.

For every marker the difference between the position stated in \code{estmap} 
and in \code{realmap} is calculated (see \code{\link{get.dist.loci}}).

Every difference is squared and the mean of the square differences is returned.

Note that where different weights are used in estimating maps, it is valid to 
compare the mean distance from the truth. However, if different map functions 
are used then the distances are not comparable. 

Therefore, if there is some knowledge of markers on a chromosome and data is 
simulated so that there is some objective knowledge of the truth then this 
function could be used to decide whether to use \code{lod} or \code{lod2} 
weightings to estimate maps attempting to locate additional markers. However, 
it is not suitable for deciding on the map functions used to calculated the 
pairwise marker distances.
}
