% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{sim.bc.rflod.file}
\alias{sim.bc.rflod.file}
\title{Simulate a backcross population from homozygous parents.}
\usage{
sim.bc.rflod.file(fname)
}
\arguments{
\item{fname}{a character string specifying the base name of the file fname.txt to which the data should be written}
}
\value{
No output - just the text file as above
}
\description{
Simulates a backcross population from homozygous parents and writes a file 
containing the number of markers and observed pairwise distances, the pairwise 
recombination fractions and LOD scores in a text file suitable for analysis by 
other functions in the package.
}
\details{
This function simply generates data for use with the vignette. The R/qtl package is used to simulate a backcross #'population of 200 individuals from homozygous parents with 200 markers in a single linkage group of length #'100cM. The recombination fractions and LOD scores are calculated. The data is written to a text file in the #'format of output from JoinMap 4.  In particular, the data is cast into a data frame with marker names in the #'first two columns, pairwise recombination fractions in the third column and associated LOD scores in the fourth #'column. The data is written to a text file 'fname.txt' where the first row contains two entries - the number of #'markers and the number of pairwise observations. Below this the data frame containing the distance data is #'appended with no column headings. 
\tabular{llll}{
\cr
\code{nmarkers} \tab \tab \tab \cr
\code{marker_1} \tab \code{marker_2} \tab \code{recombination fraction} \tab \code{lod}\cr
\code{1} \tab \code{2} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{1} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{3} \tab \code{.} \tab \code{.} \cr
\code{2} \tab \code{4} \tab \code{.} \tab \code{.} \cr
\code{.} \tab \code{.} \tab \code{.} \tab \code{.} \cr
}
}
\references{
\cite{Broman KW, Wu H, Sen S, Churchill GA (2003) R/qtl: QTL mapping in experimental crosses. Bioinformatics. 189: 889-890}
\cite{Van Ooijen JW (2006) JoinMap 4; Software for the calculation of genetic linkage maps in experimental populations. Wageningen; Netherlands: Kyazma B.V}
}
