% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCtrace.R
\name{MCMCtrace}
\alias{MCMCtrace}
\title{Trace and density plots from MCMC output}
\usage{
MCMCtrace(object, params = "all", excl = NULL, ISB = TRUE, iter = 5000,
  pdf = TRUE, filename, wd = getwd(), type = "both", ind = FALSE)
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{params}{Character string (or vector of character strings) denoting parameters of interest.

Default \code{'all'} returns chains for all parameters.}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude. Used in conjunction with \code{params} argument to select parameters of interest.}

\item{ISB}{Ignore Square Brackets (ISB). Logical specifying whether square brackets should be ignored in the \code{params} and \code{excl} arguments. If \code{FALSE}, square brackets are ignored - input from \code{params} and \code{excl} are otherwise matched exactly. If \code{TRUE}, square brackets are not ignored - input from \code{params} and \code{excl} are matched using grep, allowing partial names to be used when specifying parameters of interest.}

\item{iter}{Number of iterations to plot for trace and density plots. The default value is 5000, meaning the last 5000 iterations of the chain will be plotted.}

\item{pdf}{Logical - if \code{pdf = TRUE} plots will be exported to a pdf.}

\item{filename}{Name of pdf file to be printed. Default is 'MCMCtrace'.}

\item{wd}{Working directory for pdf output. Default is current directory.}

\item{type}{Type of plot to be output. \code{'both'} outputs both trace and density plots, \code{'trace'}
outputs only trace plots, and \code{'density'} outputs only density plots.}

\item{ind}{Logical - if \code{ind = TRUE}, separate density lines will be plotted for each chain. If
\code{ind= FALSE}, one density line will be plotted for all chains.}
}
\description{
Trace and density plots of MCMC chains for specific parameters of interest. Option to
print plots to pdf.
}
\section{Details}{

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), an \code{mcmc.list} object
(\code{coda} package), or an \code{R2jags} model object (\code{R2jags} package). The function automatically
detects the object type and proceeds accordingly.
}

\examples{
#Load data
data(MCMC_data)

#Traceplots for all 'beta' parameters
MCMCtrace(MCMC_data, params='beta')

#Traceplots (individual density lines for each chain) for just 'beta[1]'
MCMCtrace(MCMC_data, params = 'beta[1]', ISB = FALSE, filename = 'PDF_file.pdf', ind = TRUE)

}
