% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCdiag.R
\name{MCMCdiag}
\alias{MCMCdiag}
\title{Diagnostics summaries for models}
\usage{
MCMCdiag(
  object,
  file_name,
  dir = getwd(),
  mkdir,
  add_field,
  add_field_names,
  save_object = FALSE,
  obj_name,
  add_obj,
  add_obj_names,
  cp_file,
  cp_file_names,
  open_txt = TRUE,
  summary = TRUE,
  params = "all",
  excl = NULL,
  ISB = TRUE,
  exact = TRUE,
  digits = NULL,
  round = NULL
)
}
\arguments{
\item{object}{Object containing MCMC output. See DETAILS below.}

\item{file_name}{Character string with name of .txt file to be saved to \code{dir} (or \code{mkdir} if specified). If not specified, 'MCMCdiag.txt' will be used.}

\item{dir}{Character string with directory where file(s) (or directory is argument for \code{mkdir} is specified) will be created. Defaults to working directory. An absolute or relative (to the working directory) path can be used.}

\item{mkdir}{Character string with name of directory to be created. If specified, a directory will be created within the directory specified by \code{dir}.}

\item{add_field}{Object (or vector of objects) to be added to the .txt file.}

\item{add_field_names}{Character string (or vector of character strings) specifying the name(s) of the \code{add_field} object(s).}

\item{save_object}{Logical specifying whether the model output provided to the function (\code{object}) should be saved as a \code{.rds} file to \code{dir} (or \code{mkdir} if specified). Note that \code{.rds} files can be opened with \code{rdsRDS()}.}

\item{obj_name}{Character string specifying the file name of the \code{.rds} file (created from \code{object}) if \code{save_object = TRUE}.}

\item{add_obj}{List with additional object(s) to be saved as \code{.rds} files to \code{dir} (or \code{mkdir} if specified). Objects can be of any types. Multiple objects can be specified. Note that \code{.rds} files can be opened with \code{rdsRDS()}.}

\item{add_obj_names}{Character string (or vector of character strings) specifying the name(s) of the objects to be saved as \code{.rds} files, specified with \code{add_obj}.}

\item{cp_file}{Character string (or vector of character strings) specifying file(s) to be copied to \code{dir} (or \code{mkdir} if specified). Absolute or relative (to the working directory) paths can be used.}

\item{cp_file_names}{Character string (or vector of character strings) specifying new names for files to be copied specified by \code{cp_file}. If not argument is provided, the copy names will be identical to the originals.}

\item{open_txt}{Logical - if \code{open_txt = TRUE} .txt file will open in default .txt viewer after being generated.}

\item{summary}{Logical specifying whether or not to output summary information from MCMCsummary (posterior mean, sd, 2.5th and 97.5th quantiles, Rhat, and n.eff) at the bottom of the .txt file.}

\item{params}{Character string (or vector of character strings) denoting parameters to be returned in summary output. Argument is ignored if \code{summary = FALSE}.

#' Default \code{'all'} returns all parameters in summary output.}

\item{excl}{Character string (or vector of character strings) denoting parameters to exclude. Used in conjunction with \code{params} argument to select parameters of interest. Argument is ignored if \code{summary = FALSE}.}

\item{ISB}{Ignore Square Brackets (ISB). Logical specifying whether square brackets should be ignored in the \code{params} and \code{excl} arguments. If \code{TRUE}, square brackets are ignored. If \code{FALSE}, square brackets are not ignored.  This allows partial names to be used when specifying parameters of interest. Use \code{exact} argument to specify whether input from \code{params} and \code{excl} arguments should be matched exactly.}

\item{exact}{Logical specifying whether input from \code{params} and \code{excl} arguments should be matched exactly (after ignoring square brackets if \code{ISB = FALSE}). If \code{TRUE}, input from \code{params} and \code{excl} are matched exactly (after taking \code{ISB} argument into account). If \code{FALSE}, input from \code{params} and \code{excl} are matched using regular expression format (after taking \code{ISB} argument into account).}

\item{digits}{Number of significant digits to include for posterior summary. All computed digits will be included by default. Note that Rhat is always rounded to 2 decimal places.}

\item{round}{Number of decimal places to round to for posterior summary. Cannot be used in conjunction with \code{digits} argument. Note that Rhat is always rounded to 2 decimal places.}
}
\description{
Model diagnostics and summary. Function reads information embedded in model fit object. Output varies by model fit object type but includes model run inputs, diagnostic information, and parameter summary. See DETAILS below for more information.
}
\section{Details}{

Some diagnostic information is only provided for models fit with particular pieces of software. For example, \code{rstan} output includes additional diagnostics related to the NUTS sampler. Output from \code{jagsUI} includes runtime information, but output from \code{rjags} does not. Note that this information could be fed manually to the function using the \code{add_field} argument.

\code{object} argument can be a \code{stanfit} object (\code{rstan} package), a \code{stanreg} object (\code{rstanarm} package), a \code{brmsfit} object (\code{brms} package), an \code{mcmc.list} object (\code{coda} and \code{rjags} packages), \code{mcmc} object (\code{coda} and \code{nimble} packages), \code{list} object (\code{nimble} package), an \code{R2jags} model object (\code{R2jags} package), a \code{jagsUI} model object (\code{jagsUI} package), or a matrix containing MCMC chains (each column representing MCMC output for a single parameter, rows representing iterations in the chain). The function automatically detects the object type and proceeds accordingly.

Output presented in .txt file varies by model fit object type but includes: model run time, number of warmup/burn-in iterations, total iterations, thinning rate, number of chains, specified adapt delta, specified max tree depth, specific initial step size, mean accept stat, mean tree depth, mean step size, number of divergent transitions, number max tree depth exceeds, number of chains with BFMI warnings, max Rhat (maximum Rhat of any parameter printed), min n.eff (minimum n.eff of any parameter printed), parameter summary information (passed from \code{MCMCsummary}), and any additional information fed to the \code{add_field} argument. See documentation for specific software used to fit model for more information on particular diagnostics.
}

\examples{
#Load data
data(MCMC_data)

# MCMCdiag(MCMC_data,
#          #name of .txt file to be saved
#          file_name = 'blog-model-summary-2021-01-15',
#          #directory within which to save .txt file
#          dir = '~/Desktop',
#          #round MCMCsummary output in .txt file to two digits
#          round = 2,
#          #add two fields to .txt file
#          add_field = c(50, '1.0'),
#          #names of two additional fields to add to .txt file
#          add_field_names = c('Time (min)', 'Data version'))

}
