% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RIM.R
\name{RIM}
\alias{RIM}
\title{Implementation of RIM Method for Multi-Criteria Decision Making Problems.}
\usage{
RIM(decision, weights, AB, CD)
}
\arguments{
\item{decision}{The decision matrix (\emph{m} x \emph{n}) with the values of the \emph{m} alternatives, for the \emph{n} criteria.}

\item{weights}{A vector of length \emph{n}, containing the weights for the criteria. The sum of the weights has to be 1.}

\item{AB}{A matrix (\emph{2} x \emph{n}). AB[1,] corresponds with the A extrem, and AB[2,] represents the B extrem of the domain of each criterion.}

\item{CD}{A matrix (\emph{2} x \emph{n}). CD[1,] corresponds with the C extrem, and CD[2,] represents the D extrem of the ideal reference of each criterion.}
}
\value{
\code{RIM} returns a data frame which contains the score of the R index and the ranking of the alternatives.
}
\description{
The \code{RIM} function implements the Reference Ideal Method (RIM).
}
\examples{

 d <- matrix(c(30,40,25,27,45,0,9,0,0,15,2,1,3,5,2,3,3,1,3,2,3,2,3,3,3,2,2,2,1,4),
 nrow = 5, ncol = 6)
 w <- c(0.2262,0.2143,0.1786,0.1429,0.119,0.119)
 AB = matrix(c(23,60,0,15,0,10,1,3,1,3,1,5),nrow = 2,ncol = 6)
 CD = matrix(c(30,35,10,15,0,0,3,3,3,3,4,5),nrow = 2,ncol = 6)
 RIM(d,w,AB,CD)
}
\references{
Cables, E.; Lamata, M.T.; Verdegay, J.L. RIM-reference ideal method in multicriteria decision making. Information Science, 337-338, 1-10, 2016.
}

