% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inconsistency.functions.R, R/nodesplit-class.R
\name{mbnma.nodesplit}
\alias{mbnma.nodesplit}
\alias{plot.nodesplit}
\title{Node-splitting model for testing consistency at the treatment level using MBNMA}
\usage{
mbnma.nodesplit(
  network,
  fun = dpoly(degree = 1),
  method = "common",
  comparisons = NULL,
  incldr = TRUE,
  ...
)

\method{plot}{nodesplit}(x, plot.type = "forest", ...)
}
\arguments{
\item{network}{An object of class \code{mbnma.network}.}

\item{fun}{An object of \code{class("dosefun")} that specifies a functional form to be assigned to the
dose-response. See Details.}

\item{method}{Can take either \code{"common"} or \code{"random"} to indicate whether relative effects
should be modelled with between-study heterogeneity or not (see details).}

\item{comparisons}{A matrix specifying the comparisons to be split (one row per comparison).
The matrix must have two columns indicating each treatment for each comparison. Values can
either be character (corresponding to the treatment names given in \code{network}) or
numeric (corresponding to treatment codes within the \code{network} - note that these
may change if \code{drop.discon = TRUE}).}

\item{incldr}{A boolean object indicating whether or not to allow for indirect evidence contributions via
the dose-response relationship. This can be used when node-splitting in dose-response MBNMA to allow
for a greater number of potential loops in which to check for consistency.}

\item{...}{Arguments to be sent to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} or \code{forestplot::forestplot()}}

\item{x}{An object of \code{class("nodesplit")}}

\item{plot.type}{A character string that can take the value of \code{"forest"} to plot
forest plots or \code{"density"} to plot posterior density plots.}
}
\value{
Plots the desired graph if \code{plot.type="forest"} and plots and returns an object
of \code{class(c("gg", "ggplot"))} if \code{plot.type="density"}.
}
\description{
Splits contributions for a given set of treatment comparisons into direct and
indirect evidence. A discrepancy between the two suggests that the consistency
assumption required for NMA and MBNMA may violated.
}
\details{
The S3 method \code{plot()} on an \code{nodesplit} object generates either
forest plots of posterior medians and 95\\\% credible intervals, or density plots
of posterior densities for direct and indirect evidence.
}
\section{Functions}{
\itemize{
\item \code{plot(nodesplit)}: Plot outputs from treatment-level nodesplit MBNMA models

}}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(triptans)

split <- mbnma.nodesplit(network, fun=demax(), likelihood = "binomial", link="logit",
  method="common")


#### To perform nodesplit on selected comparisons ####

# Check for closed loops of treatments with independent evidence sources
# Including indirect evidence via the dose-response relationship
loops <- inconsistency.loops(network$data.ab, incldr=TRUE)

# This...
single.split <- mbnma.nodesplit(network, fun=dexp(), likelihood = "binomial", link="logit",
             method="random", comparisons=rbind(c("sumatriptan_1", "almotriptan_1")))

#...is the same as...
single.split <- mbnma.nodesplit(network, fun=dexp(), likelihood = "binomial", link="logit",
             method="random", comparisons=rbind(c(6, 12)))


# Plot results
plot(split, plot.type="density") # Plot density plots of posterior densities
plot(split, txt_gp=forestplot::fpTxtGp(cex=0.5)) # Plot forest plots (with smaller label size)

# Print and summarise results
print(split)
summary(split) # Generate a data frame of summary results
}
}
