% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbnma-class.R
\name{plot.mbnma}
\alias{plot.mbnma}
\title{Forest plot for results from dose-response MBNMA models}
\usage{
\method{plot}{mbnma}(x, params = NULL, agent.labs = NULL, class.labs = NULL, ...)
}
\arguments{
\item{x}{An S3 object of class \code{"mbnma"} generated by running
a dose-response MBNMA model}

\item{params}{A character vector of dose-response parameters to plot.
Parameters must be given the same name as monitored nodes in \code{mbnma} and must be
modelled as relative effects (\code{"rel"}). Can be set to
\code{NULL} to include all available dose-response parameters estimated by \code{mbnma}.}

\item{agent.labs}{A character vector of agent labels (including \code{"Placebo"} if it
has been included in the original network). If left as \code{NULL} (the default) then
labels will be used as defined in the data.}

\item{class.labs}{A character vector of class labels if \code{mbnma} was modelled using class effects
(including \code{"Placebo"} if it
has been included in the original network). If left as \code{NULL}
(the default) then labels will be used as defined in the data.}

\item{...}{Arguments to be passed to methods, such as graphical parameters}
}
\value{
A forest plot of class \code{c("gg", "ggplot")} that has separate panels for
different dose-response parameters. Results are plotted on the link scale.
}
\description{
Generates a forest plot for dose-response parameters.
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

# Run an exponential dose-response MBNMA and generate the forest plot
exponential <- mbnma.run(network, fun="exponential")
plot(exponential)

# Plot only Emax parameters from an Emax dose-response MBNMA
emax <- mbnma.emax(network, emax="rel", ed50="rel", method="random")
plot(emax, params=c("d.emax"))


#### Forest plots including class effects ####
# Generate some classes for the data
class.df <- HF2PPITT
class.df$class <- ifelse(class.df$agent=="placebo", "placebo", "active1")
class.df$class <- ifelse(class.df$agent=="eletriptan", "active2", class.df$class)
netclass <- mbnma.network(class.df)
emax <- mbnma.emax(netclass, emax="rel", ed50="rel", method="random",
            class.effect=list("ed50"="common"))

# Plot forest plot with different labels for classes
plot(emax, class.labs=c("Placebo", "Other Active", "Eletriptan"))

# Since "Placebo" is included in the network, it must be included in labels
# Failure to do so will cause an error
## ERROR ## plot(emax, class.labs=c("Other Active", "Eletriptan"))
}

}
