% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbnma.network-class.R, R/prepare.functions.R
\name{plot.mbnma.network}
\alias{plot.mbnma.network}
\alias{mbnma.network}
\title{Create an mbnma.network object}
\usage{
\method{plot}{mbnma.network}(
  x,
  level = "treatment",
  v.color = "connect",
  doselink = NULL,
  layout = igraph::in_circle(),
  remove.loops = FALSE,
  edge.scale = 1,
  v.scale = NULL,
  label.distance = 0,
  legend = TRUE,
  legend.x = "bottomleft",
  legend.y = NULL,
  ...
)

mbnma.network(data.ab, description = "Network")
}
\arguments{
\item{x}{An object of class \code{mbnma.network}.}

\item{level}{A string indicating whether nodes/facets should represent \code{"treatment"}
or \code{"agent"} in the plot. Can be used to examine the expected impact of modelling
dose-response in terms of network connectivity.}

\item{v.color}{Can take either \code{"connect"} (the default) to indicate that nodes should
only be coloured if they are connected to the network reference treatment (indicates
network connectivity) or \code{"agent"} to colour nodes by agent.}

\item{doselink}{If given an integer value it indicates that connections via the dose-response
relationship with placebo should be plotted. The integer represents the minimum number of doses
from which a dose-response function could be estimated and is equivalent to the number of
parameters in the desired dose-response function plus one. If left as \code{NULL} (the default), connections
to placebo via dose-response relationships will not be included.}

\item{layout}{An igraph layout specification. This is a function specifying an igraph
layout that determines the arrangement of the vertices (nodes). The default
\code{igraph::as_circle()} arranged vertices in a circle. Two other useful layouts for
network plots are: \code{igraph::as_star()}, \code{igraph::with_fr()}. Others can be found
in \code{\link[igraph]{layout_}}}

\item{remove.loops}{A boolean value indicating whether to include loops that
indicate comparisons within a node.}

\item{edge.scale}{A number to scale the thickness of connecting lines
(edges). Line thickness is proportional to the number of studies for a
given comparison. Set to 0 to make thickness equal for all comparisons.}

\item{v.scale}{A number with which to scale the size of the nodes. If the variable \code{N}
(to indicate the numbers of participants in each study arm) is included in the
dataset then the size of the nodes will be proportional to the number of participants
within a treatment/agent in the network.}

\item{label.distance}{A number scaling the distance of labels from the nodes
to improve readability. The labels will be directly on top of the nodes if
the default of 0 is used. Option only applicable if \code{layout_in_circle} is
set to \code{TRUE}.}

\item{legend}{A boolean object to indicate whether or not to plot a legend to indicate which node colour
corresponds to which agent if \code{v.color="agent"}. Default is \code{TRUE}.}

\item{legend.x, legend.y}{The x and y co-ordinates to be used to position the legend. They can be specified
by keyword or in any way which is accepted by \code{xy.coords}.}

\item{...}{Options for plotting in \code{igraph}.}

\item{data.ab}{A data frame of arm-level data in "long" format containing the columns:
\itemize{
\item \code{studyID} Study identifiers
\item \code{dose} Numeric data indicating the dose (must take positive values)
\item \code{agent} Agent identifiers (can be numeric, factor or character)
\item \code{y} Numeric data indicating the aggregate response for a continuous outcome. Required for
continuous data.
\item \code{se} Numeric data indicating the standard error for a given observation. Required for
continuous data.
\item \code{r} Numeric data indicating the number of responders within a study arm. Required for
binomial or poisson data.
\item \code{N} Numeric data indicating the total number of participants within a study arm. Required for
binomial data
\item \code{E} Numeric data indicating the total exposure time for participants within a study arm. Required
for poisson data.
\item \code{class} An optional column indicating a particular class code. Agents with the same identifier
must also have the same class code.
}}

\item{description}{Optional. Short description of the network.}
}
\value{
\code{plot()}: An object of \code{class("igraph")} - any functions from the \code{igraph} package
can be applied to this object to change its characteristics.

\code{mbnma.network()}: An object of \code{class("mbnma.network")} which is a list containing:
\itemize{
\item \code{description} A short description of the network
\item \code{data.ab} A data frame containing the arm-level network data (treatment identifiers will have
been recoded to a sequential numeric code)
\item \code{agents} A character vector indicating the agent identifiers that correspond to the
new agent codes.
\item \code{treatments} A character vector indicating the treatment identifiers that correspond
to the new treatment codes.
\item \code{classes} A character vector indicating the class identifiers (if included in the original data)
that correspond to the new class codes.
}
}
\description{
Creates an object of class \code{mbnma.network}. Various MBNMA functions can subsequently be applied
to this object.
}
\details{
The S3 method \code{plot()} on an \code{mbnma.network} object generates a
network plot that shows how different treatments are connected within the
network via study comparisons. This can be used to identify how direct and
indirect evidence are informing different treatment comparisons. Depends on
\code{\link[igraph]{igraph}}.

Agents/classes for arms that have dose = 0 will be relabelled as \code{"Placebo"}.
Missing values (\code{NA}) cannot be included in the dataset. Single arm studies cannot
be included.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Generate a network plot
}}

\examples{
# Create an mbnma.network object from the data
network <- mbnma.network(HF2PPITT)

# Generate a network plot from the data
plot(network)

# Generate a network plot at the agent level that removes loops indicating comparisons
#within a node
plot(network, level="agent", remove.loops=TRUE)

# Generate a network plot at the treatment level that colours nodes by agent
plot(network, v.color="agent", remove.loops=TRUE)

# Generate a network plot that includes connections via the dose-response function
# For a one parameter dose-response function (e.g. exponential)
plot(network, level="treatment", doselink=1, remove.loops=TRUE)

# For a two parameter dose-response function (e.g. Emax)
plot(network, level="treatment", doselink=2, remove.loops=TRUE)

# Arrange network plot in a star with the reference treatment in the centre
plot(network, layout=igraph::as_star(), label.distance=3)

#### Plot a network with no placebo data included ####
# Make data with no placebo
noplac.df <- network$data.ab[network$data.ab$narm>2 & network$data.ab$agent!=1,]
net.noplac <- mbnma.network(noplac.df)

# Plotting network automatically plots connections to Placebo via dose-response
plot(net.noplac)
# Using the triptans headache dataset
print(HF2PPITT)

# Define network
network <- mbnma.network(HF2PPITT, description="Example")

# Plot network
plot(network)

}
