% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIM.R
\name{DIM}
\alias{DIM}
\title{Select best direction using cross-validation}
\usage{
DIM(rd)
}
\arguments{
\item{rd}{the result of MAVE function}
}
\value{
rd contains cross-validation values of corresponding
direction
}
\description{
This function selects the dimension of the central (mean)  space
based on the calculation of MAVE  using cross-validation method
}
\examples{
 x <- matrix(rnorm(200*5),200,5)
 b1 <- matrix(c(1,1,0,0,0),5,1)
 b2 <- matrix(c(0,0,1,1,0),5,1)
 eps <- matrix(rnorm(200),200,1)
 y <- x\%*\%b1 + (x\%*\%b2)*eps

 rd1 <- MAVE(x,y,'csmave')
 rd2 <- MAVE(x,y,'meanmave')

 rd1 <- DIM(rd1)
 rd2 <- DIM(rd2)
}

