% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/box_cox.R
\name{lambda}
\alias{lambda}
\alias{lambda.formula}
\alias{lambda.lm}
\alias{lambda.box_cox}
\alias{lambda.default}
\title{Find the box-cox transform exponent estimate}
\usage{
lambda(bc, ...)

\method{lambda}{formula}(bc, data = sys.parent(), ..., span = 5)

\method{lambda}{lm}(bc, ..., span = 5)

\method{lambda}{box_cox}(bc, ..., span = 5)

\method{lambda}{default}(bc, ...)
}
\arguments{
\item{bc}{either a \code{"box_cox"} object, a formula,data pair, a linear model object or an xy-lixt}

\item{...}{additional parameters passed on to \code{box_cox}}

\item{data}{a data frame or envinonment}

\item{span}{integer: how many steps on either side of the maximum to use for the quadratic interpolation to find the maximum}
}
\value{
numeric: the maximum likelihood estimate of the exponent
}
\description{
Estimates the box-cox power transformation appropriate for
a linear model
}
\examples{
lambda(medv ~ ., Boston, span = 10)
}
