% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_3_Compute_A5SS.R
\name{ComputePSI.A5SS}
\alias{ComputePSI.A5SS}
\title{Compute alternative 5' splice site (A5SS) percent spliced-in (PSI) values}
\usage{
ComputePSI.A5SS(MarvelObject, CoverageThreshold)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}
}
\value{
An object of class S3 with new slots \code{$SpliceFeatureValidated$A5SS} and \code{$PSI$A5SS}.
}
\description{
Validate A5SS splicing events and subsequently computes percent spliced-in (PSI) values these high-quality splicing events.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.A5SS(MarvelObject=marvel.demo,
                               CoverageThreshold=10
                               )
}
