% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_03_PREPROCESS_2_2_SubsetSamples_Gene.R
\name{SubsetSamples.Gene}
\alias{SubsetSamples.Gene}
\title{Subset Samples (Cells) for gene data}
\usage{
SubsetSamples.Gene(MarvelObject, columns, variables)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{columns}{Character string. To indicate which columns in the \code{MarvelObject$GenePheno} slot to refer to when filtering samples (cells).}

\item{variables}{List of character string. To indicate which specific variables of the corresponding columns to keep the samples (cells). This should be same length as the \code{columns} argument.}
}
\value{
An object of class S3. The original \code{MarvelObject$GenePheno} slot is replaced with the new filtered phenoData.
}
\description{
\code{SubsetSamples} subsets samples (cells) based on user-defined criteria for gene data.
}
\details{
This function subset samples (cells) based on user-defined criteria, e.g. samples passing sequencing QC. These criteria are reflected in the columns of the \code{MarvelObject$GenePheno} slot.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- SubsetSamples.Gene(MarvelObject=marvel,
                             columns=c("qc.seq", "sample.type", "cell.type"),
                             variables=list("pass", "Single Cell", c("iPSC", "Endoderm"))
                             )
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
