% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_06_DE_1_2_CompareValues_Exp.R
\name{CompareValues.Exp}
\alias{CompareValues.Exp}
\title{Differential Gene Expression Analysis}
\usage{
CompareValues.Exp(
  MarvelObject,
  cell.type.columns.1,
  cell.type.variables.1,
  cell.type.columns.2,
  cell.type.variables.2,
  n.cells,
  method,
  method.adjust
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{ComputePSI} function.}

\item{cell.type.columns.1}{Character string. To indicate which columns in the \code{MarvelObject$GenePheno} slot to refer to when filtering samples (cells) for analysis. This is for the first group of cells (reference group).}

\item{cell.type.variables.1}{List of character string. To indicate which specific variables of the corresponding columns to keep the samples (cells). This should be same length as the \code{cell.type.columns} argument. This is for the first group of cells (reference group).}

\item{cell.type.columns.2}{Character string. To indicate which columns in the \code{MarvelObject$GenePheno} slot to refer to when filtering samples (cells) for analysis. This is for the 2nd group of cells (non-reference group).}

\item{cell.type.variables.2}{List of character string. To indicate which specific variables of the corresponding columns to keep the samples (cells). This should be same length as the \code{cell.type.columns} argument. This is for the 2nd group of cells  (non-reference group).}

\item{n.cells}{Numeric value. The minimum no. of cells expressing the splicing event for the event to be included for differential splicing analysis.}

\item{method}{Character string. Statistical test to compare the 2 groups of cells. \code{"ks"}, \code{"kuiper"}, \code{"ad"}, \code{"wilcox"}, and \code{"t.test"} for Kolmogorov-Smirnov, Kuiper, Anderson-Darling, Wilcox, and t-test, respectively.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$DE$Gene}
}
\description{
\code{CompareValues.Exp} performs differentially gene expression analysis between 2 groups of cells.
}
\details{
This function compares the gene expression values between 2 groups of cells.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CompareValues.Exp(MarvelObject=marvel,
                            cell.type.columns.1=c("cell.type"),
                            cell.type.variables.1=list("iPSC"),
                            cell.type.columns.2=c("cell.type"),
                            cell.type.variables.2=list("Endoderm"),
                            n.cells=2,
                            method="t.test",
                            method.adjust="fdr"
                            )

# Check output
marvel$DE$Exp$Table[1:5, ]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
