% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateOverlapPlot.R
\name{generateOverlapPlot}
\alias{generateOverlapPlot}
\title{Function to generate Overlap plot}
\usage{
generateOverlapPlot(
  mymaf,
  use_silent_mutations = FALSE,
  summarize_by = "gene",
  plotType = c("ribbon", "heatmap"),
  savename = NULL,
  savewidth = 8,
  saveheight = 8
)
}
\arguments{
\item{mymaf}{The MAF object}

\item{use_silent_mutations}{Flag to use the silent mutations
in the plot}

\item{summarize_by}{Paramter to summarize the data
(Either 'gene' or 'mutation'")}

\item{plotType}{The type of plot generated ("ribbon"
or "heatmap" or both)}

\item{savename}{The name and path of the output file}

\item{savewidth}{Width of plot}

\item{saveheight}{Height of plot}
}
\value{
No return value, the plot is saved as a pdf
}
\description{
This function generates an overlap plot
using the MAF data.
}
\examples{

library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
\donttest{generateOverlapPlot(read.maf(maf))}
}
\author{
Mayank Tandon, Ashish Jain
}
